/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.Prediction;

public class TIFFPrediction
extends Prediction {
    public TIFFPrediction(COSDictionary options) {
        super(options);
    }

    protected void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) {
        if (this.getBitsPerComponent() != 8) {
            return;
        }
        int colors = this.getColors();
        int columns = this.getColumns();
        int index = 0;
        while (index < colors) {
            result[resultOffset + index] = source[sourceOffset + index];
            ++index;
        }
        int byteIndex = 1;
        while (byteIndex < columns) {
            int colorIndex = 0;
            while (colorIndex < colors) {
                result[resultOffset + byteIndex * colors + colorIndex] = (byte)(result[resultOffset + (byteIndex - 1) * colors + colorIndex] + source[sourceOffset + byteIndex * colors + colorIndex]);
                ++colorIndex;
            }
            ++byteIndex;
        }
    }

    public int getRowSize() {
        return this.getColumns() * this.getColors();
    }
}

