/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeStringType;
import de.intarsys.nativec.type.NativeType;

public class NativeString
extends NativeObject {
    public static final NativeStringType META = new NativeStringType();
    private int size = 0;
    private NativeStringType type;

    static {
        NativeType.register(NativeString.class, META);
    }

    public static NativeString createFromAddress(long address) {
        return (NativeString)META.createNative(NativeTools.toHandle(address));
    }

    protected NativeString(NativeStringType pType) {
        this.type = pType;
        this.allocate();
    }

    protected NativeString(NativeStringType pType, INativeHandle handle) {
        super(handle);
        this.type = pType;
        if (this.type.hasByteCount()) {
            handle.setSize(this.type.getByteCount());
        }
    }

    protected NativeString(NativeStringType pType, String value) {
        this.type = pType;
        if (this.type.getStringSize() == 0) {
            this.size = value.length() + 1;
        }
        this.allocate();
        this.setValue(value);
    }

    public NativeString(String value) {
        this(META, value);
    }

    public int getByteCount() {
        if (this.type.hasByteCount()) {
            return this.type.getByteCount();
        }
        return this.size;
    }

    public INativeType getNativeType() {
        return this.type;
    }

    public Object getValue() {
        return this.stringValue();
    }

    public void setValue(Object value) {
        this.setValue((String)value);
    }

    public void setValue(String value) {
        this.size = value.length() + 1;
        this.handle.setString(0, value);
    }

    public String stringValue() {
        return this.handle.getString(0);
    }
}

