/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSSpecial;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSIndexed
extends AwtCSSpecial {
    public AwtCSIndexed(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    protected ColorSpace createColorSpace() {
        throw new UnsupportedOperationException();
    }

    protected int[] extractIntRGBS(int colors) {
        if (this.myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
            return this.extractIntRGBsDirect(colors);
        }
        return this.extractIntRGBsOther(colors);
    }

    protected int[] extractIntRGBsDirect(int colors) {
        int[] rgbs = new int[colors];
        int index = 0;
        while (index < colors) {
            rgbs[index] = 0xFF000000 | this.myPDColorSpace().getColorBytes()[index * 3] << 16 & 0xFF0000 | this.myPDColorSpace().getColorBytes()[index * 3 + 1] << 8 & 0xFF00 | this.myPDColorSpace().getColorBytes()[index * 3 + 2] & 0xFF;
            ++index;
        }
        return rgbs;
    }

    protected int[] extractIntRGBsOther(int colors) {
        ColorSpace colorSpace = AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getColorSpace();
        int numComponents = colorSpace.getNumComponents();
        int[] rgbs = new int[colors];
        int index = 0;
        while (index < colors) {
            float[] input = new float[numComponents];
            int component = 0;
            while (component < numComponents) {
                input[component] = (float)(0xFF & this.myPDColorSpace().getColorBytes()[index * numComponents + component]) / 255.0f;
                ++component;
            }
            float[] output = colorSpace.toRGB(input);
            rgbs[index] = 0xFF000000 | (int)(output[0] * 255.0f) << 16 | (int)(output[1] * 255.0f) << 8 & 0xFF00 | (int)(output[2] * 255.0f) & 0xFF;
            ++index;
        }
        return rgbs;
    }

    public ColorModel getColorModel(PDImage pdImage) {
        int bits = pdImage.getBitsPerComponent();
        int colors = 1 << bits;
        if (this.myPDColorSpace().getColorCount() < colors) {
            colors = this.myPDColorSpace().getColorCount();
        }
        return new IndexColorModel(bits, colors, this.extractIntRGBS(colors), 0, false, -1, 0);
    }

    public int getNumComponents() {
        return 1;
    }

    public float[] getRGB(float[] values) {
        float[] colorValues = new float[AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getNumComponents()];
        int index = 0;
        while (index < colorValues.length) {
            colorValues[index] = (float)(this.myPDColorSpace().getColorBytes()[(int)values[0] * AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getNumComponents() + index] & 0xFF) / 255.0f;
            ++index;
        }
        return AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getRGB(colorValues);
    }

    protected PDCSIndexed myPDColorSpace() {
        return (PDCSIndexed)this.getPDColorSpace();
    }
}

