/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.GifEncoder;
import ij.plugin.PlugIn;

public class GifWriter
implements PlugIn {
    static int transparentIndex = Prefs.getTransparentIndex();

    public void run(String path) {
        ImagePlus imp = IJ.getImage();
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog("Save as Gif", imp.getTitle(), ".gif");
            if (sd.getFileName() == null) {
                return;
            }
            path = sd.getDirectory() + sd.getFileName();
        }
        ImageStack stack = imp.getStack();
        ImagePlus tmp = new ImagePlus();
        int nSlices = stack.getSize();
        GifEncoder ge = new GifEncoder();
        double fps = imp.getCalibration().fps;
        if (fps == 0.0) {
            fps = Animator.getFrameRate();
        }
        if (fps <= 0.2) {
            fps = 0.2;
        }
        if (fps > 60.0) {
            fps = 60.0;
        }
        ge.setDelay((int)(1.0 / fps * 1000.0));
        if (transparentIndex != -1) {
            ge.transparent = true;
            ge.transIndex = transparentIndex;
        }
        ge.start(path);
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress((double)i / (double)nSlices);
            tmp.setProcessor(null, stack.getProcessor(i));
            try {
                ge.addFrame(tmp);
                continue;
            }
            catch (Exception e) {
                IJ.showMessage("Save as Gif", "" + e);
                return;
            }
        }
        ge.finish();
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }
}

