/*
 * Decompiled with CFR 0.152.
 */
package JSci.chemistry;

import JSci.chemistry.Element;
import JSci.chemistry.Molecule;
import JSci.physics.Particle;
import JSci.physics.particles.Electron;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.Neutron;
import JSci.physics.particles.Nucleon;
import JSci.physics.particles.Proton;

public class Atom
extends Particle {
    private Lepton[] shell;
    private final int shellSize;
    private Nucleon[] nucleus;
    private final int nucleusSize;

    public Atom(Element element) {
        this.shellSize = element.getAtomicNumber();
        this.nucleusSize = element.getMassNumber();
    }

    public Nucleon[] getNucleus() {
        if (this.nucleus == null) {
            int n;
            this.nucleus = new Nucleon[this.nucleusSize];
            for (n = 0; n < this.shellSize; ++n) {
                this.nucleus[n] = new Proton();
            }
            while (n < this.nucleusSize) {
                this.nucleus[n] = new Neutron();
                ++n;
            }
        }
        return this.nucleus;
    }

    public Lepton[] getShell() {
        if (this.shell == null) {
            this.shell = new Lepton[this.shellSize];
            for (int i = 0; i < this.shellSize; ++i) {
                this.shell[i] = new Electron();
            }
        }
        return this.shell;
    }

    public Molecule bind(Atom atom) {
        return new Molecule(this, atom);
    }
}

