/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class CauchyDistribution
extends ProbabilityDistribution {
    private double alpha;
    private double gamma;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double d, double d2) {
        if (d2 < 0.0) {
            throw new OutOfRangeException("The scale parameter should be positive.");
        }
        this.alpha = d;
        this.gamma = d2;
    }

    public double getLocationParameter() {
        return this.alpha;
    }

    public double getScaleParameter() {
        return this.gamma;
    }

    public double probability(double d) {
        double d2 = d - this.alpha;
        return this.gamma / (Math.PI * (this.gamma * this.gamma + d2 * d2));
    }

    public double cumulative(double d) {
        return 0.5 + Math.atan((d - this.alpha) / this.gamma) / Math.PI;
    }

    public double inverse(double d) {
        this.checkRange(d);
        return this.alpha - this.gamma / Math.tan(Math.PI * d);
    }
}

