/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf3_5;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf3_5.CDF3_5;

public final class DualScaling3_5
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static CDF3_5 cdf = new CDF3_5();

    public boolean equals(Object object) {
        if (object != null && object instanceof DualScaling3_5) {
            DualScaling3_5 dualScaling3_5 = (DualScaling3_5)object;
            return this.dimension(0) == dualScaling3_5.dimension(0) && this.position() == dualScaling3_5.position();
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public int getFilterType() {
        return 2;
    }

    public DualScaling3_5(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Object clone() {
        DualScaling3_5 dualScaling3_5 = (DualScaling3_5)super.clone();
        dualScaling3_5.n0 = this.n0;
        dualScaling3_5.k = this.k;
        return dualScaling3_5;
    }

    public DualScaling3_5() {
    }

    public void setParameters(int n, int n2) {
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        this.n0 = n;
        this.k = n2;
    }

    public double[] evaluate(int n) {
        return cdf.evalScaling(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 2);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

