/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArray;
import de.intarsys.nativec.type.NativeType;

public class NativeArrayType
extends NativeType {
    private final int arraySize;
    private final int baseSize;
    private final INativeType baseType;

    public static NativeArrayType create(INativeType baseType, int size) {
        return new NativeArrayType(baseType, size);
    }

    protected NativeArrayType(INativeType baseDeclaration, int arraySize) {
        this.baseType = baseDeclaration;
        this.baseSize = baseDeclaration.getByteCount();
        this.arraySize = arraySize;
    }

    public INativeObject createNative(INativeHandle handle) {
        NativeArray array = new NativeArray(this, handle);
        if (this.arraySize > 0) {
            array.setSize(this.arraySize);
        }
        return array;
    }

    public INativeObject createNative(Object value) {
        NativeArray array = new NativeArray(this);
        return array;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public int getBaseSize() {
        return this.baseSize;
    }

    public INativeType getBaseType() {
        return this.baseType;
    }

    public int getByteCount() {
        return this.arraySize * this.baseSize;
    }

    public int getPreferredBoundary() {
        return this.baseType.getPreferredBoundary();
    }
}

