/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeIntType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeType;

public class NativeInt
extends NativeNumber {
    public static final NativeIntType META = new NativeIntType();

    static {
        NativeType.register(NativeInt.class, META);
    }

    public static NativeInt createFromAddress(long address) {
        return (NativeInt)META.createNative(NativeTools.toHandle(address));
    }

    public NativeInt() {
        this.allocate();
    }

    protected NativeInt(INativeHandle handle) {
        super(handle);
    }

    public NativeInt(long value) {
        this.allocate();
        this.setValue(value);
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public INativeType getNativeType() {
        return META;
    }

    public Object getValue() {
        return new Integer(this.intValue());
    }

    public int intValue() {
        return this.handle.getInt(0);
    }

    public long longValue() {
        return this.intValue();
    }

    public void setValue(int value) {
        this.handle.setInt(0, value);
    }

    public void setValue(Object value) {
        this.setValue(((Number)value).intValue());
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.intValue());
    }
}

