/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public abstract class AwtColorSpace {
    public static final ColorSpace FALLBACK = new FallbackColorSpace();
    private ColorSpace colorSpace;
    private PDColorSpace pdColorSpace;

    protected static AwtColorSpace getColorSpace(PDColorSpace colorSpace) {
        return AwtColorSpaceFactory.get().createColorSpace(colorSpace);
    }

    public AwtColorSpace(PDColorSpace pdColorSpace) {
        this.pdColorSpace = pdColorSpace;
    }

    protected abstract ColorSpace createColorSpace();

    public abstract ColorModel getColorModel(PDImage var1);

    public final ColorSpace getColorSpace() {
        if (this.colorSpace == null) {
            this.colorSpace = this.createColorSpace();
        }
        return this.colorSpace;
    }

    public int getNumComponents() {
        return this.getColorSpace().getNumComponents();
    }

    public PDColorSpace getPDColorSpace() {
        return this.pdColorSpace;
    }

    public float[] getRGB(float[] values) {
        return this.getColorSpace().toRGB(values);
    }

    static class FallbackColorSpace
    extends ColorSpace {
        private ColorSpace cmykColorSpace;
        private ColorSpace grayColorSpace;
        private ColorSpace rgbColorSpace;

        FallbackColorSpace() {
            super(6, 1);
        }

        protected float[] average(float[] values) {
            if (values.length == 1) {
                return values;
            }
            float sum = 0.0f;
            float[] fArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                float value = fArray[n2];
                sum += value;
                ++n2;
            }
            return new float[]{sum / (float)values.length};
        }

        public float[] fromCIEXYZ(float[] colorvalue) {
            throw new UnsupportedOperationException();
        }

        public float[] fromRGB(float[] rgbvalue) {
            throw new UnsupportedOperationException();
        }

        protected ColorSpace getCmykColorSpace() {
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = AwtColorSpaceFactory.get().createColorSpace((PDColorSpace)PDCSDeviceCMYK.SINGLETON).getColorSpace();
            }
            return this.cmykColorSpace;
        }

        protected ColorSpace getGrayColorSpace() {
            if (this.grayColorSpace == null) {
                this.grayColorSpace = ColorSpace.getInstance(1003);
            }
            return this.grayColorSpace;
        }

        protected ColorSpace getRgbColorSpace() {
            if (this.rgbColorSpace == null) {
                this.rgbColorSpace = ColorSpace.getInstance(1003);
            }
            return this.rgbColorSpace;
        }

        public float[] toCIEXYZ(float[] colorvalue) {
            if (colorvalue.length == 3) {
                return this.getRgbColorSpace().toCIEXYZ(colorvalue);
            }
            if (colorvalue.length == 4) {
                return this.getCmykColorSpace().toCIEXYZ(colorvalue);
            }
            return this.getGrayColorSpace().toCIEXYZ(this.average(colorvalue));
        }

        public float[] toRGB(float[] colorvalue) {
            if (colorvalue.length == 3) {
                return this.getRgbColorSpace().toRGB(colorvalue);
            }
            if (colorvalue.length == 4) {
                return this.getCmykColorSpace().toRGB(colorvalue);
            }
            return this.getGrayColorSpace().toRGB(this.average(colorvalue));
        }
    }
}

