/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public class ImageConverterPdf2Awt {
    private static final float MAX_SCALE = 400000.0f;
    private BufferedImage bufferedImage;
    private final PDImage pdImage;

    protected static BufferedImage createBufferedImage(PDImage pdImage) {
        COSStream imgStream = pdImage.cosGetStream();
        if (!pdImage.hasTransparency() && (imgStream.hasFilter(Filter.CN_Filter_DCTDecode) || imgStream.hasFilter(Filter.CN_Filter_DCT) || imgStream.hasFilter(Filter.CN_Filter_JPXDecode))) {
            try {
                return ImageConverterPdf2Awt.createBufferedImageFromJPEG(pdImage, pdImage.cosExtractJPEGStream());
            }
            catch (ImageException imageException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            ColorModel colorModel = ImageConverterPdf2Awt.getColorModel(pdImage);
            WritableRaster raster = ImageConverterPdf2Awt.createRaster(pdImage, colorModel);
            return new BufferedImage(colorModel, raster, false, null);
        }
        catch (ImageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImageException((Throwable)ex);
        }
    }

    protected static BufferedImage createBufferedImageFromJPEG(PDImage pdImage, COSStream cosStream) throws IOException {
        String colorSpaceType;
        ByteArrayInputStream stream = new ByteArrayInputStream(cosStream.getEncodedBytes());
        try {
            colorSpaceType = ImageTools.extractJPEGColorSpaceType((InputStream)stream);
        }
        catch (ImageException ex) {
            colorSpaceType = "YCbCr";
        }
        if (!("GRAY".equals(colorSpaceType) || "RGB".equals(colorSpaceType) || "YCbCr".equals(colorSpaceType))) {
            throw new ImageException("AWT non-RGB/GRAY JPEG not supported");
        }
        if (!PlatformImageTools.matchColorSpace(pdImage, colorSpaceType)) {
            throw new ImageException("PD color space does not match JPEG metadata");
        }
        ((InputStream)stream).reset();
        return ImageIO.read(stream);
    }

    protected static WritableRaster createDirectRaster(PDImage pdImage, ColorModel colorModel, byte[] bytes) {
        int componentSize = pdImage.getBitsPerComponent();
        DataBufferByte dataBuffer = new DataBufferByte(bytes, bytes.length);
        if (componentSize == 1 || componentSize == 2 || componentSize == 4) {
            return Raster.createPackedRaster(dataBuffer, pdImage.getWidth(), pdImage.getHeight(), componentSize, new Point(0, 0));
        }
        if (componentSize == 8) {
            int bands = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
            int[] bandOffsets = new int[bands];
            int i = 0;
            while (i < bandOffsets.length) {
                bandOffsets[i] = i;
                ++i;
            }
            return Raster.createInterleavedRaster(dataBuffer, pdImage.getWidth(), pdImage.getHeight(), pdImage.getWidth() * bands, bands, bandOffsets, new Point(0, 0));
        }
        throw new ImageException("unsupported component depth " + componentSize);
    }

    protected static WritableRaster createRaster(PDImage pdImage, ColorModel colorModel) throws IOException {
        if (pdImage.cosGetStream().hasFilter(Filter.CN_Filter_DCTDecode) || pdImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            WritableRaster jpegRaster = ImageConverterPdf2Awt.createRasterFromJPEG(pdImage, pdImage.cosExtractJPEGStream());
            return jpegRaster;
        }
        return ImageConverterPdf2Awt.createDirectRaster(pdImage, colorModel, pdImage.getAdjustedBytes(colorModel.createCompatibleSampleModel(1, 1).getNumBands()));
    }

    protected static WritableRaster createRasterFromAnyJPEG(PDImage pdImage, InputStream stream) throws IOException {
        stream.reset();
        ImageInputStream imageStream = ImageIO.createImageInputStream(stream);
        try {
            String colorSpaceType;
            ImageReader reader = ImageIO.getImageReaders(imageStream).next();
            reader.setInput(imageStream);
            WritableRaster raster = (WritableRaster)reader.readRaster(0, null);
            try {
                colorSpaceType = ImageTools.extractJPEGColorSpaceType((ImageReader)reader);
            }
            catch (ImageException ex) {
                WritableRaster writableRaster = raster;
                reader.reset();
                reader.dispose();
                imageStream.close();
                return writableRaster;
            }
            try {
                byte[] dataElements = (byte[])raster.getDataElements(0, 0, pdImage.getWidth(), pdImage.getHeight(), null);
                if (colorSpaceType.equals("YCCK") && pdImage.getColorSpace() == PDCSDeviceCMYK.SINGLETON) {
                    int i = 0;
                    while (i < dataElements.length / 4) {
                        double y = 0xFF & dataElements[i * 4];
                        double cb = (0xFF & dataElements[i * 4 + 1]) - 128;
                        double cr = (0xFF & dataElements[i * 4 + 2]) - 128;
                        double r = y + 1.402 * cr;
                        double g = y - 0.34414 * cb - 0.71414 * cr;
                        double b = y + 1.772 * cb;
                        if (r < 0.0) {
                            r = 0.0;
                        }
                        if (r > 255.0) {
                            r = 255.0;
                        }
                        if (g < 0.0) {
                            g = 0.0;
                        }
                        if (g > 255.0) {
                            g = 255.0;
                        }
                        if (b < 0.0) {
                            b = 0.0;
                        }
                        if (b > 255.0) {
                            b = 255.0;
                        }
                        dataElements[i * 4] = (byte)(255.0 - r);
                        dataElements[i * 4 + 1] = (byte)(255.0 - g);
                        dataElements[i * 4 + 2] = (byte)(255.0 - b);
                        ++i;
                    }
                }
                AwtColorSpace platformColorSpace = AwtColorSpaceFactory.get().createColorSpace(pdImage.getColorSpace());
                WritableRaster writableRaster = ImageConverterPdf2Awt.createDirectRaster(pdImage, new ComponentColorModel(platformColorSpace.getColorSpace(), false, false, 1, 0), dataElements);
                reader.reset();
                reader.dispose();
                return writableRaster;
            }
            catch (Throwable throwable) {
                reader.reset();
                reader.dispose();
                throw throwable;
            }
        }
        finally {
            imageStream.close();
        }
    }

    protected static WritableRaster createRasterFromJPEG(PDImage pdImage, COSStream cosStream) throws IOException {
        String colorSpaceType;
        ByteArrayInputStream stream = new ByteArrayInputStream(cosStream.getEncodedBytes());
        try {
            colorSpaceType = ImageTools.extractJPEGColorSpaceType((InputStream)stream);
        }
        catch (ImageException ex) {
            colorSpaceType = "YCbCr";
        }
        ((InputStream)stream).reset();
        if ("YCbCr".equals(colorSpaceType)) {
            try {
                return ImageConverterPdf2Awt.createRasterFromYCbCrJPEG(stream);
            }
            catch (ImageException imageException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ImageConverterPdf2Awt.createRasterFromAnyJPEG(pdImage, stream);
    }

    protected static WritableRaster createRasterFromYCbCrJPEG(InputStream stream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(stream);
        if (bufferedImage == null) {
            throw new ImageException("Couldn't read JPEG");
        }
        return bufferedImage.getRaster();
    }

    protected static ColorModel getColorModel(PDImage pdImage) {
        if (pdImage.isImageMask()) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            return new IndexColorModel(1, 2, nArray, 0, false, -1, 0);
        }
        AwtColorSpace colorSpace = AwtColorSpaceFactory.get().createColorSpace(pdImage.getColorSpace());
        return colorSpace.getColorModel(pdImage);
    }

    public ImageConverterPdf2Awt(PDImage pPdImage) {
        this.pdImage = pPdImage;
    }

    protected BufferedImage createBufferedImage() {
        BufferedImage image = ImageConverterPdf2Awt.createBufferedImage(this.pdImage);
        if (!this.pdImage.hasTransparency()) {
            return image;
        }
        return this.mergeMask(image);
    }

    protected RenderedImage createColorKeyMask(BufferedImage source, byte[][] colorKeyMask) {
        int width = source.getWidth();
        int height = source.getHeight();
        SampleModel sourceSampleModel = source.getSampleModel();
        DataBuffer sourceDataBuffer = source.getRaster().getDataBuffer();
        byte[] sourceBytes = new byte[sourceSampleModel.getNumBands()];
        ComponentColorModel maskColorModel = CwtAwtImageTools.getGrayColorModel();
        WritableRaster maskRaster = ((ColorModel)maskColorModel).createCompatibleWritableRaster(width, height);
        byte[] maskBytes = new byte[]{-1};
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                boolean opaque = false;
                sourceSampleModel.getDataElements(x, y, sourceBytes, sourceDataBuffer);
                int index = 0;
                while (index < sourceBytes.length) {
                    if ((sourceBytes[index] & 0xFF) < (colorKeyMask[0][index] & 0xFF)) {
                        opaque = true;
                        break;
                    }
                    if ((sourceBytes[index] & 0xFF) > (colorKeyMask[1][index] & 0xFF)) {
                        opaque = true;
                        break;
                    }
                    ++index;
                }
                if (opaque) {
                    maskRaster.setDataElements(x, y, maskBytes);
                }
                ++y;
            }
            ++x;
        }
        BufferedImage mask = new BufferedImage(maskColorModel, maskRaster, false, null);
        return mask;
    }

    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            this.bufferedImage = this.createBufferedImage();
        }
        return this.bufferedImage;
    }

    public PDImage getPDImage() {
        return this.pdImage;
    }

    protected BufferedImage mergeMask(BufferedImage image) {
        RenderedImage mask;
        ImageLayout imageLayout;
        ColorModel colorModel;
        BufferedImage source = image;
        if (this.pdImage.getMaskImage() != null) {
            BufferedImage maskImage = ImageConverterPdf2Awt.createBufferedImage(this.pdImage.getMaskImage());
            if (this.pdImage.getMaskImage().isImageMask()) {
                colorModel = CwtAwtImageTools.getGrayColorModel();
                imageLayout = new ImageLayout(0, 0, maskImage.getWidth(), maskImage.getHeight(), colorModel.createCompatibleSampleModel(maskImage.getWidth(), maskImage.getHeight()), colorModel);
                mask = FormatDescriptor.create((RenderedImage)maskImage, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
                mask = InvertDescriptor.create((RenderedImage)mask, null);
            } else {
                mask = maskImage;
            }
        } else if (this.pdImage.getSMask() != null) {
            mask = ImageConverterPdf2Awt.createBufferedImage((PDImage)this.pdImage.getSMask());
        } else {
            byte[][] colorKeyMask = this.pdImage.getColorKeyMask(image.getSampleModel().getNumBands());
            mask = this.createColorKeyMask(image, colorKeyMask);
        }
        float sourceScaleX = 1.0f;
        float sourceScaleY = 1.0f;
        float maskScaleX = 1.0f;
        float maskScaleY = 1.0f;
        if (source.getWidth() >= mask.getWidth()) {
            maskScaleX = (float)source.getWidth() / (float)mask.getWidth();
        } else {
            sourceScaleX = (float)mask.getWidth() / (float)source.getWidth();
        }
        if (source.getHeight() >= mask.getHeight()) {
            maskScaleY = (float)source.getHeight() / (float)mask.getHeight();
        } else {
            sourceScaleY = (float)mask.getHeight() / (float)source.getHeight();
        }
        if (sourceScaleX * sourceScaleY > 400000.0f) {
            float ratio = 400000.0f / (sourceScaleX * sourceScaleY);
            sourceScaleX *= ratio;
            sourceScaleY *= ratio;
            maskScaleX *= ratio;
            maskScaleY *= ratio;
        }
        if (maskScaleX * maskScaleY > 400000.0f) {
            float ratio = 400000.0f / (maskScaleX * maskScaleY);
            sourceScaleX *= ratio;
            sourceScaleY *= ratio;
            maskScaleX *= ratio;
            maskScaleY *= ratio;
        }
        if (sourceScaleX != 1.0f || sourceScaleY != 1.0f) {
            source = ScaleDescriptor.create((RenderedImage)source, (Float)Float.valueOf(sourceScaleX), (Float)Float.valueOf(sourceScaleY), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        if (maskScaleX != 1.0f || maskScaleY != 1.0f) {
            mask = ScaleDescriptor.create((RenderedImage)mask, (Float)Float.valueOf(maskScaleX), (Float)Float.valueOf(maskScaleY), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        int width = source.getWidth();
        int height = source.getHeight();
        colorModel = mask.getColorModel();
        if (!(colorModel instanceof ComponentColorModel)) {
            colorModel = CwtAwtImageTools.getGrayColorModel();
            imageLayout = new ImageLayout(0, 0, 512, 512, colorModel.createCompatibleSampleModel(width, height), colorModel);
            mask = FormatDescriptor.create((RenderedImage)mask, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        }
        if (!((colorModel = source.getColorModel()) instanceof ComponentColorModel)) {
            colorModel = CwtAwtImageTools.getRgbColorModel();
            imageLayout = new ImageLayout(0, 0, width, height, colorModel.createCompatibleSampleModel(width, height), colorModel);
            source = FormatDescriptor.create((RenderedImage)source, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        }
        colorModel = new ComponentColorModel(colorModel.getColorSpace(), true, false, 3, colorModel.getTransferType());
        imageLayout = new ImageLayout(0, 0, width, height, colorModel.createCompatibleSampleModel(width, height), colorModel);
        return BandMergeDescriptor.create((RenderedImage)source, (RenderedImage)mask, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout)).getRendering().getAsBufferedImage();
    }
}

