/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.CommonDumpObject;
import de.intarsys.tools.logging.IDumpObject;
import de.intarsys.tools.logging.LogConfigurator;
import java.io.IOException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogTools {
    private static IDumpObject DumpObject = new CommonDumpObject();
    public static final String INDENT = "    ";

    public static void closeFileLogger(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            handlers[i].close();
            ++i;
        }
    }

    public static Logger createFileLogger(String id, String filePattern, boolean append) throws SecurityException, IOException {
        Logger logger = Logger.getLogger(id);
        FileHandler handler = new FileHandler(filePattern, append);
        logger.addHandler(handler);
        return logger;
    }

    public static List<String> dumpObject(String prefix, Object object) {
        return LogTools.dumpObject(prefix, object, DumpObject);
    }

    public static List<String> dumpObject(String prefix, Object object, IDumpObject details) {
        return DumpObject.dump(prefix, object, details);
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = Logger.getLogger(LogTools.toLoggerName(clazz));
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static Logger getLogger(String name) {
        Logger logger = Logger.getLogger(name);
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static String toLoggerName(Class<?> clazz) {
        String result = clazz.getName();
        int index = result.lastIndexOf(46);
        if (index > -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    private LogTools() {
    }
}

