/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public abstract class AbstractSingleCompress
extends AbstractTransformer {
    private static final long serialVersionUID = -7648311276417258437L;
    protected boolean m_RemoveInputFile;
    protected PlaceholderFile m_Output;
    protected int m_BufferSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove", "removeInputFile", (Object)false);
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("buffer", "bufferSize", (Object)1024);
    }

    protected abstract String getDefaultExtension();

    public void setRemoveInputFile(boolean value) {
        this.m_RemoveInputFile = value;
        this.reset();
    }

    public boolean getRemoveInputFile() {
        return this.m_RemoveInputFile;
    }

    public String removeInputFileTipText() {
        return "If set to true, then the original input file will be deleted after a successful compression.";
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public abstract String outputTipText();

    public void setBufferSize(int value) {
        this.m_BufferSize = value;
        this.reset();
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of the buffer in bytes for the data stream.";
    }

    public String getQuickInfo() {
        String result = "output is ";
        String variable = this.getOptionManager().getVariableForProperty("output");
        result = variable != null ? result + variable : (this.m_Output != null && !this.m_Output.isDirectory() ? result + this.m_Output.toString() : result + "<incoming>" + this.getDefaultExtension());
        if (this.m_RemoveInputFile) {
            result = result + ", remove <incoming>";
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected abstract String compress(File var1, File var2);

    protected String doExecute() {
        File inFile = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            inFile = (File)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            inFile = new PlaceholderFile((String)this.m_InputToken.getPayload());
        }
        String output = this.m_Output.isDirectory() ? inFile.getAbsolutePath() + this.getDefaultExtension() : this.m_Output.getAbsolutePath();
        File outFile = new File(output);
        String result = this.compress(inFile, outFile);
        if (result == null) {
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

