/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.NullAppearanceCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.attribute.Attribute;

public class AppearanceCreatorTools {
    private static final Attribute ATTR_APPEARANCECREATOR = new Attribute("appearanceCreator");

    public static void createAppearance(PDAcroFormField field) {
        IAppearanceCreator appearanceCreator = AppearanceCreatorTools.getAppearanceCreator(field);
        for (PDAnnotation annot : field.getAnnotations()) {
            AppearanceCreatorTools.createAppearance(annot, appearanceCreator);
        }
    }

    public static PDAppearance createAppearance(PDAnnotation annotation) {
        IAppearanceCreator appearanceCreator = AppearanceCreatorTools.getAppearanceCreator(annotation);
        return AppearanceCreatorTools.createAppearance(annotation, appearanceCreator);
    }

    public static PDAppearance createAppearance(PDAnnotation annotation, IAppearanceCreator appearanceCreator) {
        if (appearanceCreator == null) {
            COSName type = annotation.cosGetSubtype();
            appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(type);
            if (appearanceCreator == null) {
                appearanceCreator = new NullAppearanceCreator();
            }
        }
        PDAppearance appearance = appearanceCreator.createAppearance(annotation, null);
        annotation.setAppearance(appearance);
        return appearance;
    }

    public static IAppearanceCreator getAppearanceCreator(PDObject fieldOrAnntotation) {
        return (IAppearanceCreator)fieldOrAnntotation.getAttribute(ATTR_APPEARANCECREATOR);
    }

    public static void setAppearanceCreator(PDObject fieldOrAnntotation, IAppearanceCreator appearanceCreator) {
        fieldOrAnntotation.setAttribute(ATTR_APPEARANCECREATOR, appearanceCreator);
    }
}

