/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import weka.classifiers.sequence.core.State;
import weka.classifiers.sequence.core.Transition;

public class BaumWelchTransition
implements Serializable,
Transition {
    private static final long serialVersionUID = 6451290502090237197L;
    private double probability;
    private double expectationLogCount;
    private State start;
    private State end;

    public BaumWelchTransition(State start, State end) {
        this.start = start;
        this.end = end;
        this.probability = 0.0;
        this.expectationLogCount = Double.NEGATIVE_INFINITY;
    }

    public BaumWelchTransition(double probability, State start, State end) {
        this.probability = probability;
        this.start = start;
        this.end = end;
        this.expectationLogCount = Double.NEGATIVE_INFINITY;
    }

    @Override
    public State getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(State end) {
        this.end = end;
    }

    @Override
    public double getProbability() {
        return this.probability;
    }

    @Override
    public void setProbability(double probability) {
        this.probability = probability;
    }

    @Override
    public State getStart() {
        return this.start;
    }

    @Override
    public void setStart(State start) {
        this.start = start;
    }

    @Override
    public boolean equals(Transition toCompare) {
        if (this.probability != toCompare.getProbability()) {
            return false;
        }
        if (!this.start.equals(toCompare.getStart())) {
            return false;
        }
        return this.end.equals(toCompare.getEnd());
    }

    @Override
    public String toString() {
        return this.start.getFullNameId() + "-" + this.end.getFullNameId() + " (" + this.probability + ")";
    }

    public double getExpectationLogCount() {
        return this.expectationLogCount;
    }

    public void setExpectationLogCount(double expectationLogCount) {
        this.expectationLogCount = expectationLogCount;
    }
}

