/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.License;
import adams.core.SerializedObject;
import adams.core.annotation.MixedCopyright;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Utils {
    public static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String doubleToStringFixed(double value, int afterDecimalPoint) {
        StringBuilder result;
        if (afterDecimalPoint < 0 || value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            result = new StringBuilder(Double.toString(value));
        } else {
            double factor = Math.pow(10.0, afterDecimalPoint);
            double valueNew = Math.floor(value * factor) / factor;
            result = new StringBuilder(Long.toString(Math.round(Math.floor(valueNew))));
            StringBuilder remainder = new StringBuilder("" + Math.round((valueNew - Math.floor(valueNew)) * Math.pow(10.0, afterDecimalPoint)));
            remainder.delete(0, remainder.indexOf(".") + 1);
            if (afterDecimalPoint > 0) {
                while (remainder.length() < afterDecimalPoint) {
                    remainder.append('0');
                }
                result.append('.');
                result.append(remainder.substring(0, afterDecimalPoint));
            }
        }
        return result.toString();
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            int dotPosition;
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            for (dotPosition = stringBuffer.length() - afterDecimalPoint; precisionValue < 0L && dotPosition < 1 || dotPosition < 0; ++dotPosition) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, '0');
                    continue;
                }
                stringBuffer.insert(0, '0');
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, '0');
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, '0');
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int i;
        int dotPosition;
        String tempString = Utils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 32;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }

    public static Class getArrayClass(Class c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array, boolean outputClass) {
        StringBuilder result = new StringBuilder();
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result.append("null");
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                if (Array.get(array, i) == null) {
                    result.append("null");
                    continue;
                }
                Object obj = Array.get(array, i);
                if (outputClass) {
                    if (obj instanceof Class) {
                        result.append(((Class)obj).getName());
                        continue;
                    }
                    result.append(obj.getClass().getName());
                    continue;
                }
                result.append(obj.toString());
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("[" + Utils.arrayToString(Array.get(array, i)) + "]");
            }
        }
        return result.toString();
    }

    public static String arrayToString(Object array) {
        return Utils.arrayToString(array, false);
    }

    public static String backQuoteChars(String string, char[] find, String[] replace) {
        for (int i = 0; i < find.length; ++i) {
            int index;
            if (string.indexOf(find[i]) == -1) continue;
            StringBuilder newStr = new StringBuilder();
            while ((index = string.indexOf(find[i])) != -1) {
                if (index > 0) {
                    newStr.append(string.substring(0, index));
                }
                newStr.append(replace[i]);
                if (index + 1 < string.length()) {
                    string = string.substring(index + 1);
                    continue;
                }
                string = "";
            }
            newStr.append(string);
            string = newStr.toString();
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        return Utils.backQuoteChars(string, new char[]{'\\', '\'', '\t', '\n', '\r', '\"'}, new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""});
    }

    public static String unbackQuoteChars(String string, String[] find, char[] replace) {
        int[] pos = new int[find.length];
        String str = new String(string);
        StringBuilder newStr = new StringBuilder();
        while (str.length() > 0) {
            int curPos = str.length();
            int index = -1;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = str.indexOf(find[i]);
                if (pos[i] <= -1 || pos[i] >= curPos) continue;
                index = i;
                curPos = pos[i];
            }
            if (index == -1) {
                newStr.append(str);
                str = "";
                continue;
            }
            newStr.append(str.substring(0, pos[index]));
            newStr.append(replace[index]);
            str = str.substring(pos[index] + find[index].length());
        }
        return newStr.toString();
    }

    public static String unbackQuoteChars(String string) {
        return Utils.unbackQuoteChars(string, new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""}, new char[]{'\\', '\'', '\t', '\n', '\r', '\"'});
    }

    public static String doubleQuote(String string) {
        return Utils.quote(string, "\"");
    }

    public static String quote(String string) {
        return Utils.quote(string, "'");
    }

    public static String quote(String string, String quoteChar) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1) {
            string = Utils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = new String(quoteChar).concat(string).concat(new String(quoteChar));
        }
        return string;
    }

    public static String unDoubleQuote(String string) {
        return Utils.unquote(string, "\"");
    }

    public static String unquote(String string) {
        return Utils.unquote(string, "'");
    }

    public static String unquote(String string, String quoteChar) {
        if (string.startsWith(quoteChar) && string.endsWith(quoteChar) && ((string = string.substring(1, string.length() - 1)).indexOf("\\n") != -1 || string.indexOf("\\r") != -1 || string.indexOf("\\'") != -1 || string.indexOf("\\\"") != -1 || string.indexOf("\\\\") != -1 || string.indexOf("\\t") != -1)) {
            string = Utils.unbackQuoteChars(string);
        }
        return string;
    }

    public static Object deepCopy(Object o) {
        Object result;
        try {
            SerializedObject so = new SerializedObject((Serializable)o);
            result = so.getObject();
        }
        catch (Exception e) {
            System.err.println("Failed to serialize " + o.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Object newInstance(Object o) {
        Object result;
        try {
            result = o.getClass().newInstance();
        }
        catch (Exception e) {
            System.err.println("Error creating new instance for " + o.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String[] breakUp(String s, int columns) {
        Vector<String> result = new Vector<String>();
        String punctuation = " .,;:!?'\"";
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            BreakIterator boundary = BreakIterator.getWordInstance();
            boundary.setText(lines[i]);
            int boundaryStart = boundary.first();
            int boundaryEnd = boundary.next();
            String line = "";
            while (boundaryEnd != -1) {
                String word = lines[i].substring(boundaryStart, boundaryEnd);
                if (line.length() >= columns) {
                    if (word.length() == 1 && punctuation.indexOf(word.charAt(0)) > -1) {
                        line = line + word;
                        word = "";
                    }
                    result.add(line);
                    line = "";
                }
                line = line + word;
                boundaryStart = boundaryEnd;
                boundaryEnd = boundary.next();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String insertLineBreaks(String s, int columns) {
        StringBuffer result = new StringBuffer();
        String[] lines = Utils.breakUp(s, columns);
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(lines[i]);
        }
        return result.toString();
    }

    public static String shorten(String s, int max) {
        if (s.length() > max) {
            return s.substring(0, max) + "...";
        }
        return s;
    }

    public static byte[] loadByteArrayFromFile(File file) {
        byte[] result;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bytesIn = null;
        try {
            int ch;
            bis = new BufferedInputStream(new FileInputStream(file));
            bytesIn = new ByteArrayOutputStream();
            while ((ch = bis.read()) != -1) {
                bytesIn.write(ch);
            }
            bis.close();
            result = bytesIn.toByteArray();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static String commentOut(String s, String comment) {
        return Utils.indent(s, comment);
    }

    public static String indent(String s, int numBlanks) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < numBlanks; ++i) {
            indent.append(" ");
        }
        return Utils.indent(s, indent.toString());
    }

    protected static String indent(String s, String indentStr) {
        StringBuffer result = new StringBuffer();
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            result.append(indentStr);
            result.append(lines[i]);
            result.append("\n");
        }
        return result.toString();
    }

    public static String unComment(String s, String comment) {
        StringBuffer result = new StringBuffer();
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(comment)) {
                result.append(lines[i].substring(comment.length()));
            } else {
                result.append(lines[i]);
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String flatten(List<String> lines, String newLine) {
        return Utils.flatten(lines.toArray(new String[lines.size()]), newLine);
    }

    public static String flatten(String[] lines, String newLine) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(newLine);
            }
            result.append(lines[i]);
        }
        return result.toString();
    }

    public static void removeEmptyLines(Vector<String> lines) {
        Utils.removeEmptyLines(lines, true);
    }

    public static void removeEmptyLines(Vector<String> lines, boolean trim) {
        int i = 0;
        while (i < lines.size()) {
            String line = trim ? lines.get(i).trim() : lines.get(i);
            if (line.length() == 0) {
                lines.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static void removeComments(Vector<String> lines, String comment) {
        int i = 0;
        while (i < lines.size()) {
            if (lines.get(i).startsWith(comment)) {
                lines.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static int compare(Comparable o1, Comparable o2) {
        if (o1 != null && o2 != null) {
            return o1.compareTo(o2);
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        return 1;
    }

    public static Object adjustArray(Object array, int newLen, Object defValue) {
        boolean serializable = defValue instanceof Serializable;
        Object result = Array.newInstance(defValue.getClass(), newLen);
        for (int i = 0; i < Array.getLength(result); ++i) {
            if (serializable) {
                Array.set(result, i, Utils.deepCopy(defValue));
                continue;
            }
            Array.set(result, i, defValue);
        }
        if (array != null) {
            System.arraycopy(array, 0, result, 0, Array.getLength(array) < Array.getLength(result) ? Array.getLength(array) : Array.getLength(result));
        }
        return result;
    }

    public static String classToString(Class c) {
        String result = c.isArray() ? c.getComponentType().getName() + "[]" : c.getName();
        return result;
    }

    public static float[] toFloat(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    public static double[] toDouble(float[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static String padLeft(String s, char padding, int width) {
        return Utils.padLeft(s, padding, width, false);
    }

    public static String padLeft(String s, char padding, int width, boolean truncate) {
        StringBuilder result = new StringBuilder(s);
        while (result.length() < width) {
            result.insert(0, padding);
        }
        if (truncate && result.length() > width) {
            result.delete(0, result.length() - width);
        }
        return result.toString();
    }

    public static String throwableToString(Throwable t) {
        return Utils.throwableToString(t, -1);
    }

    public static String throwableToString(Throwable t, int maxLines) {
        StringBuilder result;
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        if (maxLines > 0) {
            result = new StringBuilder();
            String[] lines = writer.toString().split("\n");
            for (int i = 0; i < maxLines; ++i) {
                if (i > 0) {
                    result.append("\n");
                }
                result.append(lines[i]);
            }
        } else {
            result = new StringBuilder(writer.toString());
        }
        return result.toString();
    }

    public static String getStackTrace(int maxDepth) {
        StringBuilder result = new StringBuilder();
        Throwable th = new Throwable();
        th.fillInStackTrace();
        StackTraceElement[] trace = th.getStackTrace();
        if (maxDepth <= 0) {
            maxDepth = trace.length - 1;
        }
        ++maxDepth;
        maxDepth = Math.min(maxDepth, trace.length);
        for (int i = 1; i < maxDepth; ++i) {
            if (i > 1) {
                result.append("\n");
            }
            result.append(trace[i]);
        }
        return result.toString();
    }

    public static Vector<Integer> toBase(int n, int base) {
        int times;
        Vector<Integer> result = new Vector<Integer>();
        int current = n;
        do {
            times = current / base;
            int remainder = current - times * base;
            result.add(remainder);
            current = times;
        } while (times > 0);
        return result;
    }

    @MixedCopyright(copyright="2006 Dr. Herong Yang", author="Dr. Herong Yang", license=License.PUBLIC_DOMAIN, url="http://www.herongyang.com/Cryptography/SHA1-Message-Digest-in-Java.html")
    public static String toHex(byte value) {
        StringBuilder result = new StringBuilder();
        result.append(HEX_DIGIT[value >> 4 & 0xF]);
        result.append(HEX_DIGIT[value & 0xF]);
        return result.toString();
    }

    public static boolean isByte(String s) {
        try {
            Byte.parseByte(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShort(String s) {
        try {
            Short.parseShort(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String s) {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] split(String line, char delimiter) {
        return Utils.split(line, "" + delimiter);
    }

    public static String[] split(String line, String delimiter) {
        int currPos;
        ArrayList<String> result = new ArrayList<String>();
        int lastPos = -1;
        while ((currPos = line.indexOf(delimiter, lastPos + 1)) > -1) {
            result.add(line.substring(lastPos + 1, currPos));
            lastPos = currPos;
        }
        result.add(line.substring(lastPos + 1));
        return result.toArray(new String[result.size()]);
    }
}

