/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import JSci.maths.wavelet.IllegalScalingException;
import adams.core.CleanUpHandler;
import adams.core.ConsoleObject;
import adams.core.Debuggable;
import adams.core.io.FileUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.DebugOptionProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractOptionProducer<O, I>
extends ConsoleObject
implements Debuggable,
CleanUpHandler {
    private static final long serialVersionUID = 4502704821224667069L;
    protected OptionHandler m_Input;
    protected int m_DebugLevel;
    protected boolean m_UsePropertyNames;
    protected transient O m_Output;
    protected I m_LastGenerated;
    protected boolean m_OutputVariableValues;
    protected HashSet<String> m_SkippedProperties;

    public AbstractOptionProducer() {
        this.initialize();
    }

    protected void initialize() {
        this.m_DebugLevel = 0;
        this.m_UsePropertyNames = false;
        this.m_Output = this.initOutput();
        this.m_OutputVariableValues = this instanceof DebugOptionProducer;
        this.m_SkippedProperties = new HashSet();
    }

    protected void reset() {
        this.m_Input = null;
        this.m_Output = this.initOutput();
        this.m_LastGenerated = null;
    }

    public abstract String globalInfo();

    @Override
    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
        this.getDebugging().setEnabled(value > 0);
    }

    @Override
    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public String debugLevelTipText() {
        return "The level of debugging output (0 = no output).";
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    protected void debug(String msg) {
        this.debug(msg, 1);
    }

    protected void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            this.getDebugging().println(msg);
        }
    }

    protected String generateDebugString(String s) {
        return s;
    }

    public void setOutputVariableValues(boolean value) {
        this.m_OutputVariableValues = value;
    }

    public boolean getOutputVariableValues() {
        return this.m_OutputVariableValues;
    }

    public String outputVariableValuesTipText() {
        return "Whether to output the values of variables instead of the variable placeholders.";
    }

    public void setSkippedProperties(HashSet<String> value) {
        this.m_SkippedProperties = value;
        this.reset();
    }

    public HashSet<String> getSkippedProperties() {
        return this.m_SkippedProperties;
    }

    public boolean getUsePropertyNames() {
        return this.m_UsePropertyNames;
    }

    public OptionHandler getInput() {
        return this.m_Input;
    }

    protected String getOptionIdentifier(AbstractOption option) {
        if (this.getUsePropertyNames()) {
            return option.getProperty();
        }
        return "-" + option.getCommandline();
    }

    protected abstract O initOutput();

    public O getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.initOutput();
        }
        return this.m_Output;
    }

    protected Object getCurrentValue(AbstractOption option) {
        return option.getCurrentValue();
    }

    protected boolean isDefaultValue(AbstractArgumentOption option, Object value) {
        return option.isDefaultValue(value);
    }

    protected void preProduce(OptionManager manager, int index) {
    }

    public abstract I processOption(BooleanOption var1);

    public abstract I processOption(ClassOption var1);

    public abstract I processOption(AbstractArgumentOption var1);

    public I doProduce(AbstractOption option) {
        if (option instanceof BooleanOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("produce/boolean") + ": " + option);
            }
            return this.processOption((BooleanOption)option);
        }
        if (option instanceof ClassOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("produce/class") + ": " + option);
            }
            return this.processOption((ClassOption)option);
        }
        if (option instanceof AbstractArgumentOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("produce/argument") + ": " + option);
            }
            return this.processOption((AbstractArgumentOption)option);
        }
        throw new IllegalScalingException("Unhandled type of option: " + option.getClass().getName());
    }

    protected void postProduce(OptionManager manager, int index) {
    }

    protected OptionHandler checkInput(OptionHandler object) {
        if (object == null) {
            throw new IllegalStateException("Input is null!");
        }
        return object;
    }

    protected void preProduce() {
        if (this.m_Output == null) {
            this.m_Output = this.initOutput();
        }
    }

    protected void doProduce(OptionManager manager) {
        List<AbstractOption> options = manager.getOptionsList();
        for (int i = 0; i < options.size(); ++i) {
            if (this.m_SkippedProperties.contains(options.get(i).getProperty())) continue;
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("preProduce") + ": " + manager.getOwner().getClass().getName());
            }
            this.preProduce(manager, i);
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("produce") + ": " + manager.getOwner().getClass().getName());
            }
            this.m_LastGenerated = this.doProduce(options.get(i));
            if (this.getDebugLevel() > 1) {
                this.debug(this.generateDebugString("produce") + " --> " + this.m_LastGenerated, 2);
            }
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("postProduce") + ": " + manager.getOwner().getClass().getName());
            }
            this.postProduce(manager, i);
        }
    }

    protected void postProduce() {
    }

    public O produce(OptionHandler visitedObject) {
        this.reset();
        this.m_Input = this.checkInput(visitedObject);
        if (this.isDebugOn()) {
            this.debug("preVisit: " + this.m_Input.getClass().getName());
        }
        this.preProduce();
        if (this.isDebugOn()) {
            this.debug("doVisit: " + this.m_Input.getClass().getName());
        }
        this.doProduce(this.getInput().getOptionManager());
        if (this.isDebugOn()) {
            this.debug("postVisit: " + this.m_Input.getClass().getName());
        }
        this.postProduce();
        return this.getOutput();
    }

    public abstract String toString();

    public boolean write(String filename) {
        return FileUtils.writeToFile(filename, this.toString(), false);
    }

    @Override
    public void cleanUp() {
        this.m_Input = null;
        this.m_Output = null;
        this.m_LastGenerated = null;
    }

    public static String toString(Class<? extends AbstractOptionProducer> cls, OptionHandler handler) {
        String result = null;
        try {
            AbstractOptionProducer producer = cls.newInstance();
            producer.produce(handler);
            result = producer.toString();
            producer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object produce(Class<? extends AbstractOptionProducer> cls, OptionHandler handler) {
        Object result = null;
        try {
            AbstractOptionProducer producer = cls.newInstance();
            producer.produce(handler);
            result = producer.getOutput();
            producer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

