/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.report.Report;
import java.util.Vector;

public abstract class AbstractReportReader<T extends Report>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractReportReader> {
    private static final long serialVersionUID = -630224132021076920L;
    protected PlaceholderFile m_Input;

    public abstract String getFormatDescription();

    public abstract String[] getFormatExtensions();

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("input", "input", new PlaceholderFile("."));
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value == null ? new PlaceholderFile(".") : value;
        this.reset();
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The file to read and turn into a report.";
    }

    public Vector<T> read() {
        this.checkData();
        Vector<T> data = this.readData();
        this.postRead(data);
        return data;
    }

    protected void checkData() {
        if (!this.m_Input.exists()) {
            throw new IllegalStateException("Input file '" + this.m_Input + "' does not exist!");
        }
        if (this.m_Input.isDirectory()) {
            throw new IllegalStateException("No input file but directory provided ('" + this.m_Input + "')!");
        }
    }

    protected abstract Vector<T> readData();

    protected void postRead(Vector<T> data) {
        for (Report d : data) {
            d.setDatabaseID(this.determineParentID(d));
        }
    }

    protected abstract int determineParentID(Report var1);

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public abstract T newInstance();

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractReportReader shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractReportReader shallowCopy(boolean expand) {
        return (AbstractReportReader)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(AbstractReportReader.class);
    }

    public static AbstractReportReader forName(String classname, String[] options) {
        AbstractReportReader result;
        try {
            result = (AbstractReportReader)OptionUtils.forName(AbstractReportReader.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractReportReader forCommandLine(String cmdline) {
        return (AbstractReportReader)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

