/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.option.AbstractOptionHandler;
import adams.data.container.DataContainer;
import adams.data.statistics.AbstractArrayStatistic;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDataContainerStatistics<T extends DataContainer>
extends AbstractOptionHandler {
    private static final long serialVersionUID = 3772060799823458030L;
    protected String m_Prefix;
    protected AbstractArrayStatistic[] m_Statistics;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("statistic", "statistics", new AbstractArrayStatistic[0]);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the generated statistics.";
    }

    public void setStatistics(AbstractArrayStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public AbstractArrayStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to generate.";
    }

    protected void check(T cont) {
        if (this.m_Prefix.length() == 0) {
            throw new IllegalStateException("No prefix defined!");
        }
        if (this.m_Statistics.length == 0) {
            throw new IllegalStateException("No array statistics supplied!");
        }
    }

    protected abstract List<Double[]> createArrays(T var1);

    protected void calculate(int index, Double[] array, Hashtable<String, Double> values) {
        for (AbstractArrayStatistic stat : this.m_Statistics) {
            stat.clear();
            stat.add(array);
            AbstractArrayStatistic.StatisticContainer cont = stat.calculate();
            stat.clear();
            if (cont.getRowCount() <= 0) continue;
            for (int i = 0; i < cont.getColumnCount(); ++i) {
                values.put(this.m_Prefix + "-" + index + "-" + cont.getHeader(i), ((Number)cont.getCell(0, i)).doubleValue());
            }
        }
    }

    public Hashtable<String, Double> calculate(T cont) {
        this.check(cont);
        List<Double[]> arrays = this.createArrays(cont);
        if (this.isDebugOn()) {
            this.debug("# arrays: " + arrays.size());
        }
        Hashtable<String, Double> result = new Hashtable<String, Double>();
        for (int i = 0; i < arrays.size(); ++i) {
            this.calculate(i, arrays.get(i), result);
        }
        if (this.isDebugOn()) {
            this.debug("Statistics: " + result);
        }
        return result;
    }
}

