/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectionParameters
implements Serializable,
Comparable<ConnectionParameters>,
CloneHandler<ConnectionParameters> {
    private static final long serialVersionUID = -1414581492377334939L;
    public static final String PARAM_CLASS = "Class";
    public static final String PARAM_URL = "URL";
    public static final String PARAM_USER = "User";
    public static final String PARAM_PASSWORD = "Password";
    public static final String PARAM_DEBUGLEVEL = "DebugLevel";
    public static final String PARAM_CONNECTONSTARTUP = "ConnectOnStartup";
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected int m_DebugLevel;
    protected boolean m_ConnectOnStartUp;

    public ConnectionParameters() {
        this.initialize();
    }

    protected void initialize() {
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = new BasePassword();
        this.m_DebugLevel = 0;
        this.m_ConnectOnStartUp = false;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public boolean getConnectOnStartUp() {
        return this.m_ConnectOnStartUp;
    }

    public Enumeration<String> parameters() {
        Vector<String> result = new Vector<String>();
        result.add(PARAM_CLASS);
        result.add(PARAM_URL);
        result.add(PARAM_USER);
        result.add(PARAM_PASSWORD);
        result.add(PARAM_DEBUGLEVEL);
        result.add(PARAM_CONNECTONSTARTUP);
        return result.elements();
    }

    public String getParameter(String key) {
        if (key.equals(PARAM_CLASS)) {
            return this.getClass().getName();
        }
        if (key.equals(PARAM_URL)) {
            return this.m_URL;
        }
        if (key.equals(PARAM_USER)) {
            return this.m_User;
        }
        if (key.equals(PARAM_PASSWORD)) {
            return this.m_Password.stringValue();
        }
        if (key.equals(PARAM_DEBUGLEVEL)) {
            return "" + this.m_DebugLevel;
        }
        if (key.equals(PARAM_CONNECTONSTARTUP)) {
            return "" + this.m_ConnectOnStartUp;
        }
        return null;
    }

    public void setParameter(String key, String value) {
        if (key.equals(PARAM_CLASS)) {
            // empty if block
        }
        if (key.equals(PARAM_URL)) {
            this.m_URL = value;
        } else if (key.equals(PARAM_USER)) {
            this.m_User = value;
        } else if (key.equals(PARAM_PASSWORD)) {
            this.m_Password = new BasePassword(value);
        } else if (key.equals(PARAM_DEBUGLEVEL)) {
            this.m_DebugLevel = Integer.parseInt(value);
        } else if (key.equals(PARAM_CONNECTONSTARTUP)) {
            this.m_ConnectOnStartUp = Boolean.parseBoolean(value);
        }
    }

    protected ConnectionParameters newInstance() {
        return new ConnectionParameters();
    }

    @Override
    public ConnectionParameters getClone() {
        ConnectionParameters result = this.newInstance();
        Enumeration<String> keys = this.parameters();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.setParameter(key, this.getParameter(key));
        }
        return result;
    }

    @Override
    public int compareTo(ConnectionParameters o) {
        if (o == null) {
            return 1;
        }
        Enumeration<String> keys = this.parameters();
        int result = 0;
        while (result == 0 && keys.hasMoreElements()) {
            String key = keys.nextElement();
            String oThis = this.getParameter(key);
            String oOther = o.getParameter(key);
            if (oOther == null) {
                result = 1;
                continue;
            }
            if (!(oThis instanceof Comparable)) continue;
            result = ((Comparable)((Object)oThis)).compareTo(oOther);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionParameters) {
            return this.compareTo((ConnectionParameters)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return new String(this.m_URL + "\t" + this.m_User).hashCode();
    }

    public String toString() {
        return this.m_URL.replaceAll(".*\\/\\/", "");
    }

    public AbstractDatabaseConnection toDatabaseConnection(Class dbcon) {
        AbstractDatabaseConnection result;
        try {
            result = (AbstractDatabaseConnection)dbcon.newInstance();
            result.setURL(this.getURL());
            result.setUser(this.getUser());
            result.setPassword(this.getPassword());
            result.setDebugLevel(this.getDebugLevel());
            result.setConnectOnStartUp(this.getConnectOnStartUp());
        }
        catch (Exception e) {
            System.err.println("Failed to create database connection object:");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static ConnectionParameters forName(String classname) {
        ConnectionParameters result;
        try {
            result = (ConnectionParameters)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            result = new ConnectionParameters();
        }
        return result;
    }
}

