/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.core.Variables;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;

public class FlowVariables
extends Variables {
    private static final long serialVersionUID = 1085438226194687237L;
    public static final String PREFIX_GLOBALACTOR = "global:";
    public static final String GLOBALREF_NOT_FOUND = "GlobalRefNotFound";
    protected AbstractActor m_Flow = null;
    protected GlobalActorHelper m_Helper = new GlobalActorHelper();

    public void setFlow(AbstractActor value) {
        this.m_Flow = value;
    }

    public AbstractActor getFlow() {
        return this.m_Flow;
    }

    public boolean hasFlow() {
        return this.m_Flow != null;
    }

    @Override
    public void assign(Variables other) {
        super.assign(other);
        if (other instanceof FlowVariables) {
            this.setFlow(((FlowVariables)other).getFlow());
        }
    }

    @Override
    public boolean has(String name) {
        if (FlowVariables.isGlobalReference(name)) {
            return true;
        }
        return super.has(name);
    }

    protected String getGlobalActorValue(String name, String defValue) {
        String msg;
        String result;
        block10: {
            result = defValue;
            AbstractActor global = this.m_Helper.findGlobalActor(this.m_Flow, new GlobalActorReference(name));
            msg = null;
            if (global != null) {
                if (ActorUtils.isSource(global)) {
                    try {
                        msg = global.execute();
                        if (msg != null) break block10;
                        OutputProducer prod = (OutputProducer)((Object)global);
                        if (prod.hasPendingOutput()) {
                            Token output = prod.output();
                            if (output.getPayload() != null) {
                                result = output.getPayload().toString();
                            } else {
                                msg = "Null token produced!";
                            }
                            break block10;
                        }
                        msg = "No output produced!";
                    }
                    catch (Exception e) {
                        msg = Utils.throwableToString(e);
                    }
                } else {
                    msg = "Not a source actor!";
                }
            } else {
                msg = "Not found - invalid reference?";
            }
        }
        if (msg != null) {
            System.err.println("Failed to obtain variable value from global actor '" + name + "':");
            System.err.println(msg);
        }
        return result;
    }

    @Override
    public String get(String name, String defValue) {
        name = FlowVariables.extractName(name);
        if (this.hasFlow() && name.startsWith(PREFIX_GLOBALACTOR)) {
            return this.getGlobalActorValue(name.substring(PREFIX_GLOBALACTOR.length()), defValue);
        }
        return super.get(name, defValue);
    }

    protected String doExpandGlobalRefs(String s) {
        String result = s;
        String part = "@{global:";
        if (result.indexOf(part) > -1) {
            String name;
            String fullname;
            int pos = -1;
            while ((result = result.replace(fullname = result.substring(pos = result.indexOf(part, pos + 1), result.indexOf("}", pos) + 1), this.getGlobalActorValue(name = FlowVariables.extractName(fullname).substring(PREFIX_GLOBALACTOR.length()), GLOBALREF_NOT_FOUND))).indexOf(part, pos) > -1) {
            }
        }
        return result;
    }

    @Override
    protected String doExpand(String s) {
        String result = this.doExpandGlobalRefs(s);
        result = super.doExpand(result);
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Flow = null;
        super.cleanUp();
    }

    public static boolean isGlobalReference(String name) {
        name = FlowVariables.extractName(name);
        return name.startsWith(PREFIX_GLOBALACTOR);
    }
}

