/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;

public abstract class AbstractMatchWekaInstanceAgainstHeader
extends AbstractConversion {
    private static final long serialVersionUID = -7728745365733721265L;
    protected Instances m_Dataset;

    protected void reset() {
        super.reset();
        this.m_Dataset = null;
    }

    public Class accepts() {
        return Instance.class;
    }

    public Class generates() {
        return Instance.class;
    }

    protected abstract Instances getDatasetHeader();

    protected String isCompatible(Instance input) {
        String result = null;
        if (input.numAttributes() != this.m_Dataset.numAttributes()) {
            result = "Number of attributes differ";
        }
        if (result == null) {
            for (int i = 0; i < this.m_Dataset.numAttributes(); ++i) {
                int typeHeader;
                int typeInput = input.attribute(i).type();
                if (typeInput == (typeHeader = this.m_Dataset.attribute(i).type()) || typeInput == 1 && typeHeader == 2 || typeInput == 2 && typeHeader == 1) continue;
                result = "Attribute types at #" + (i + 1) + "  are not ";
                break;
            }
        }
        return result;
    }

    protected Instance match(Instance input) {
        double[] values = new double[this.m_Dataset.numAttributes()];
        block6: for (int i = 0; i < this.m_Dataset.numAttributes(); ++i) {
            values[i] = Utils.missingValue();
            switch (this.m_Dataset.attribute(i).type()) {
                case 0: 
                case 3: {
                    values[i] = input.value(i);
                    continue block6;
                }
                case 1: {
                    if (this.m_Dataset.attribute(i).indexOfValue(input.stringValue(i)) == -1) continue block6;
                    values[i] = this.m_Dataset.attribute(i).indexOfValue(input.stringValue(i));
                    continue block6;
                }
                case 2: {
                    values[i] = this.m_Dataset.attribute(i).addStringValue(input.stringValue(i));
                    continue block6;
                }
                case 4: {
                    values[i] = this.m_Dataset.attribute(i).addRelation(input.relationalValue(i));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)this.m_Dataset.attribute(i).type()));
                }
            }
        }
        Object result = input instanceof SparseInstance ? new SparseInstance(input.weight(), values) : new DenseInstance(input.weight(), values);
        result.setDataset(this.m_Dataset);
        if (input.classIndex() != this.m_Dataset.classIndex() && this.m_Dataset.classIndex() < 0) {
            this.m_Dataset.setClassIndex(input.classIndex());
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        Instance input;
        String error;
        Instance result = null;
        if (this.m_Dataset == null) {
            this.m_Dataset = new Instances(this.getDatasetHeader(), 0);
            if (this.m_Dataset == null) {
                throw new IllegalStateException("Failed to obtain header!");
            }
        }
        if ((error = this.isCompatible(input = (Instance)this.m_Input)) != null) {
            throw new IllegalArgumentException("Input is not compatible: " + error);
        }
        result = this.match(input);
        return result;
    }
}

