/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

public enum EvaluationStatistic implements EnumWithCustomDisplay<EvaluationStatistic>
{
    NUMBER_CORRECT("Number correct (nominal)"),
    NUMBER_INCORRECT("Number incorrect (nominal)"),
    NUMBER_UNCLASSIFIED("Number unclassified (nominal)"),
    PERCENT_CORRECT("Percent correct (nominal)"),
    PERCENT_INCORRECT("Percent incorrect (nominal)"),
    PERCENT_UNCLASSIFIED("Percent unclassified (nominal)"),
    KAPPA_STATISTIC("Kappa statistic (nominal)"),
    MEAN_ABSOLUTE_ERROR("Mean absolute error"),
    ROOT_MEAN_SQUARED_ERROR("Root mean squared error"),
    RELATIVE_ABSOLUTE_ERROR("Relative absolute error"),
    ROOT_RELATIVE_SQUARED_ERROR("Root relative squared error"),
    CORRELATION_COEFFICIENT("Correlation coefficient (numeric)"),
    SF_PRIOR_ENTROPY("SF prior entropy"),
    SF_SCHEME_ENTROPY("SF scheme entropy"),
    SF_ENTROPY_GAIN("SF entropy gain"),
    SF_MEAN_PRIOR_ENTROPY("SF mean prior entropy"),
    SF_MEAN_SCHEME_ENTROPY("SF mean scheme entropy"),
    SF_MEAN_ENTROPY_GAIN("SF mean entropy gain"),
    KB_INFORMATION("KB information (nominal)"),
    KB_MEAN_INFORMATION("KB mean information (nominal)"),
    KB_RELATIVE_INFORMATION("KB relative information (nominal)"),
    TRUE_POSITIVE_RATE("True positive rate (nominal)"),
    NUM_TRUE_POSITIVES("Num true positives (nominal)"),
    FALSE_POSITIVE_RATE("False positive rate (nominal)"),
    NUM_FALSE_POSITIVES("Num false positives (nominal)"),
    TRUE_NEGATIVE_RATE("True negative rate (nominal)"),
    NUM_TRUE_NEGATIVES("Num true negatives (nominal)"),
    FALSE_NEGATIVE_RATE("False negative rate (nominal)"),
    NUM_FALSE_NEGATIVES("Num false negatives (nominal)"),
    IR_PRECISION("IR precision (nominal)"),
    IR_RECALL("IR recall (nominal)"),
    F_MEASURE("F measure (nominal)"),
    MATTHEWS_CORRELATION_COEFFICIENT("Matthews correlation coefficient (nominal)"),
    AREA_UNDER_ROC("Area under ROC (nominal)"),
    AREA_UNDER_PRC("Area under PRC (nominal)"),
    WEIGHTED_TRUE_POSITIVE_RATE("Weighted true positive rate (nominal)"),
    WEIGHTED_FALSE_POSITIVE_RATE("Weighted false positive rate (nominal)"),
    WEIGHTED_TRUE_NEGATIVE_RATE("Weighted true negative rate (nominal)"),
    WEIGHTED_FALSE_NEGATIVE_RATE("Weighted false negative rate (nominal)"),
    WEIGHTED_IR_PRECISION("Weighted IR precision (nominal)"),
    WEIGHTED_IR_RECALL("Weighted IR recall (nominal)"),
    WEIGHTED_F_MEASURE("Weighted F measure (nominal)"),
    WEIGHTED_MATTHEWS_CORRELATION_COEFFICIENT("Weighted Matthews correlation coefficient (nominal)"),
    WEIGHTED_AREA_UNDER_ROC("Weighted area under ROC (nominal)"),
    WEIGHTED_AREA_UNDER_PRC("Weighted area under PRC (nominal)");

    private String m_Display;
    private String m_Raw;

    private EvaluationStatistic(String display) {
        this.m_Display = display;
        this.m_Raw = super.toString();
    }

    public String toDisplay() {
        return this.m_Display;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public EvaluationStatistic parse(String s) {
        return EvaluationStatistic.valueOf((AbstractOption)null, s);
    }

    public String getField() {
        return this.m_Display.replaceAll(" .*", "");
    }

    public String toString() {
        return this.m_Display;
    }

    public static String toString(AbstractOption option, Object object) {
        return ((EvaluationStatistic)((Object)object)).toRaw();
    }

    public static EvaluationStatistic valueOf(AbstractOption option, String str) {
        EvaluationStatistic result = null;
        try {
            result = EvaluationStatistic.valueOf(str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            for (EvaluationStatistic f : EvaluationStatistic.values()) {
                if (!f.toDisplay().equals(str)) continue;
                result = f;
                break;
            }
        }
        return result;
    }
}

