/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseText;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;

public class WekaEvaluationSummary
extends AbstractTransformer {
    private static final long serialVersionUID = 8082115424369061977L;
    protected boolean m_OutputRelationName;
    protected boolean m_ComplexityStatistics;
    protected boolean m_ClassDetails;
    protected BaseText m_Comment;

    public String globalInfo() {
        return "Generates a summary string of the weka.classifiers.Evaluation objects that it receives.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("relation", "outputRelationName", (Object)false);
        this.m_OptionManager.add("complexity-stats", "complexityStatistics", (Object)false);
        this.m_OptionManager.add("class-details", "classDetails", (Object)false);
        this.m_OptionManager.add("comment", "comment", (Object)new BaseText(""));
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public void setOutputRelationName(boolean value) {
        this.m_OutputRelationName = value;
        this.reset();
    }

    public boolean getOutputRelationName() {
        return this.m_OutputRelationName;
    }

    public String outputRelationNameTipText() {
        return "If set to true, then the relation name of the dataset is output as well.";
    }

    public void setComplexityStatistics(boolean value) {
        this.m_ComplexityStatistics = value;
        this.reset();
    }

    public boolean getComplexityStatistics() {
        return this.m_ComplexityStatistics;
    }

    public String complexityStatisticsTipText() {
        return "If set to true, then the complexity statistics will be output as well.";
    }

    public void setClassDetails(boolean value) {
        this.m_ClassDetails = value;
        this.reset();
    }

    public boolean getClassDetails() {
        return this.m_ClassDetails;
    }

    public String classDetailsTipText() {
        return "If set to true, then the class details are output as well.";
    }

    public void setComment(BaseText value) {
        this.m_Comment = value;
        this.reset();
    }

    public BaseText getComment() {
        return this.m_Comment;
    }

    public String commentTipText() {
        return "An optional comment to output in the summary.";
    }

    protected String doExecute() {
        String result = null;
        Evaluation eval = (Evaluation)this.m_InputToken.getPayload();
        StringBuilder buffer = new StringBuilder();
        boolean prolog = false;
        if (this.m_Comment.getValue().length() > 0) {
            String[] comment = this.m_Comment.getValue().split("\n");
            if (comment.length == 1) {
                buffer.append("Comment: " + this.m_Comment + "\n");
            } else {
                buffer.append("Comment:\n");
                for (String line : comment) {
                    buffer.append(line + "\n");
                }
            }
            prolog = true;
        }
        if (this.m_OutputRelationName) {
            buffer.append("Relation: " + eval.getHeader().relationName() + "\n");
            prolog = true;
        }
        if (prolog) {
            buffer.append("\n");
        }
        buffer.append(eval.toSummaryString(this.m_ComplexityStatistics));
        if (this.m_ClassDetails) {
            try {
                buffer.append("\n\n" + eval.toClassDetailsString());
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace((Throwable)e);
                result = e.toString();
            }
        }
        this.m_OutputToken = new Token((Object)buffer.toString());
        return result;
    }
}

