/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.SpreadSheet;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;

public class WekaEvaluationValues
extends AbstractTransformer {
    private static final long serialVersionUID = -1977976026411517458L;
    protected EvaluationStatistic[] m_StatisticValues;
    protected int m_ClassIndex;

    public String globalInfo() {
        return "Generates a spreadsheet from statistics of an Evaluation object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statisticValues", (Object)new EvaluationStatistic[]{EvaluationStatistic.PERCENT_CORRECT, EvaluationStatistic.ROOT_MEAN_SQUARED_ERROR, EvaluationStatistic.ROOT_RELATIVE_SQUARED_ERROR});
        this.m_OptionManager.add("index", "classIndex", (Object)1);
    }

    public void setStatisticValues(EvaluationStatistic[] value) {
        this.m_StatisticValues = value;
        this.reset();
    }

    public EvaluationStatistic[] getStatisticValues() {
        return this.m_StatisticValues;
    }

    public String statisticValuesTipText() {
        return "The evaluation values to extract and turn into CSV.";
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class label index (eg used for AUC).";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classIndex");
        return (variable == null ? Integer.valueOf(this.m_ClassIndex) : variable) + ": " + this.m_StatisticValues.length + " values";
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class};
    }

    protected String doExecute() {
        String result = null;
        Evaluation eval = (Evaluation)this.m_InputToken.getPayload();
        SpreadSheet sheet = new SpreadSheet();
        sheet.getHeaderRow().addCell("0").setContent("Statistic");
        sheet.getHeaderRow().addCell("1").setContent("Value");
        for (EvaluationStatistic statistic : this.m_StatisticValues) {
            try {
                double value = EvaluationHelper.getValue(eval, statistic, this.m_ClassIndex);
                SpreadSheet.Row row = sheet.addRow("" + sheet.getRowCount());
                row.addCell("0").setContent(statistic.toDisplay());
                row.addCell("1").setContent(Double.toString(value));
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace((Throwable)e);
                result = "Error retrieving value for '" + (Object)((Object)statistic) + "':\n" + e;
            }
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }
}

