/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instances;

public class WekaExtractArray
extends AbstractTransformer {
    private static final long serialVersionUID = -3989993009528522476L;
    protected ExtractionType m_Type;
    protected Index m_Index;

    public String globalInfo() {
        return "Extracts a column or row of data from a weka.core.Instances or SpreadSheet object.\nOnly numeric columns can be returned. In case of row-retrieval, the value of the internal format of the weka.core.Instance object is returned; for SpreadSheet object it is attempted to convert the cell content to double (null values might get returned!).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)ExtractionType.COLUMN);
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = new Index();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("type");
        String result = variable != null ? variable : "" + (Object)((Object)this.m_Type);
        result = result + ": ";
        variable = this.getOptionManager().getVariableForProperty("index");
        result = variable != null ? result + variable : result + "" + this.m_Index.getIndex();
        return result;
    }

    public void setType(ExtractionType value) {
        this.m_Type = value;
        this.reset();
    }

    public ExtractionType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of extraction to perform, row or column.";
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the row/column to extract.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Double[].class};
    }

    protected String doExecute() {
        String result = null;
        Double[] array = null;
        if (this.m_InputToken.getPayload() instanceof Instances) {
            Instances inst = (Instances)this.m_InputToken.getPayload();
            if (this.m_Type == ExtractionType.COLUMN) {
                this.m_Index.setMax(inst.numAttributes());
            } else {
                this.m_Index.setMax(inst.numInstances());
            }
            if (this.m_Index.getIntIndex() == -1) {
                result = "Invalid index: " + this.m_Index + " (max=" + this.m_Index.getMax() + ")";
            } else if (this.m_Type == ExtractionType.COLUMN && !inst.attribute(this.m_Index.getIntIndex()).isNumeric()) {
                result = "Column " + this.m_Index + " is not numeric!";
            }
            if (result == null) {
                array = new Double[this.m_Index.getMax()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = this.m_Type == ExtractionType.COLUMN ? Double.valueOf(inst.instance(i).value(this.m_Index.getIntIndex())) : Double.valueOf(inst.instance(this.m_Index.getIntIndex()).value(i));
                }
            }
        } else {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (this.m_Type == ExtractionType.COLUMN) {
                this.m_Index.setMax(sheet.getRowCount());
            } else {
                this.m_Index.setMax(sheet.getColumnCount());
            }
            if (this.m_Index.getIntIndex() == -1) {
                result = "Invalid index: " + this.m_Index + " (max=" + this.m_Index.getMax() + ")";
            } else if (this.m_Type == ExtractionType.COLUMN && !sheet.isNumeric(this.m_Index.getIntIndex())) {
                result = "Column " + this.m_Index + " is not numeric!";
            }
            if (result == null) {
                array = new Double[this.m_Index.getMax()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = this.m_Type == ExtractionType.COLUMN ? sheet.getRow(i).getCell(this.m_Index.getIntIndex()).toDouble() : sheet.getRow(this.m_Index.getIntIndex()).getCell(i).toDouble();
                }
            }
        }
        if (array != null) {
            this.m_OutputToken = new Token((Object)array);
        }
        return result;
    }

    public static enum ExtractionType {
        COLUMN,
        ROW;

    }
}

