/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFExtract
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected PlaceholderFile m_Output;
    protected Range m_Pages;

    public String globalInfo() {
        return "Actor for extracting a range of pages from a PDF file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("pages", "pages", (Object)new Range("first-last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Pages = new Range();
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The PDF file to output the extracted pages to.";
    }

    public void setPages(Range value) {
        this.m_Pages = value;
        this.reset();
    }

    public Range getPages() {
        return this.m_Pages;
    }

    public String pagesTipText() {
        return "The range of pages to extract; " + this.m_Pages.getExample();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("pages");
        String result = variable != null ? variable : this.m_Pages.getRange();
        result = result + " -> ";
        variable = this.getOptionManager().getVariableForProperty("output");
        result = variable != null ? result + variable : result + this.m_Output.toString();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        try {
            if (this.isDebugOn()) {
                this.debug("Extracting pages from '" + file + "' into '" + this.m_Output + "'");
            }
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(this.m_Output.getAbsolutePath()));
            document.open();
            document.addCreationDate();
            document.addCreator(Environment.getInstance().getProject());
            document.addAuthor(System.getProperty("user.name"));
            PdfReader reader = new PdfReader(file.getAbsolutePath());
            if (this.isDebugOn()) {
                this.debug("- #pages: " + reader.getNumberOfPages());
            }
            this.m_Pages.setMax(reader.getNumberOfPages());
            int[] pages = this.m_Pages.getIntIndices();
            for (int i = 0; i < pages.length; ++i) {
                int page = pages[i] + 1;
                copy.addPage(copy.getImportedPage(reader, page));
                if (!this.isDebugOn()) continue;
                this.debug("- adding page: " + page);
            }
            copy.freeReader(reader);
            document.close();
        }
        catch (Exception e) {
            String msg = "Failed to extract pages: ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = msg + e;
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        }
        return result;
    }
}

