/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.io.MathMLExpression;
import JSci.mathml.MathMLDocumentImpl;
import JSci.maths.Complex;
import JSci.maths.FiniteSet;
import JSci.maths.MathDouble;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MathMLDocumentJSciImpl
extends MathMLDocumentImpl {
    public Element createNumber(double d) {
        Element element = this.createElement("cn");
        element.appendChild(this.createTextNode(String.valueOf(d)));
        return element;
    }

    public Element createNumber(int n) {
        Element element = this.createElement("cn");
        element.setAttribute("type", "integer");
        element.appendChild(this.createTextNode(String.valueOf(n)));
        return element;
    }

    public Element createNumber(Complex complex) {
        Element element = this.createElement("cn");
        element.setAttribute("type", "complex-cartesian");
        element.appendChild(this.createTextNode(String.valueOf(complex.real())));
        element.appendChild(this.createElement("sep"));
        element.appendChild(this.createTextNode(String.valueOf(complex.imag())));
        return element;
    }

    public Element createVariable(Object object) {
        Element element = this.createElement("ci");
        element.appendChild(this.createTextNode(object.toString()));
        return element;
    }

    public Element createVariable(Object object, String string) {
        Element element = this.createElement("ci");
        element.setAttribute("type", string);
        element.appendChild(this.createTextNode(object.toString()));
        return element;
    }

    public Element createVector(AbstractDoubleVector abstractDoubleVector) {
        Element element = this.createElement("vector");
        for (int i = 0; i < abstractDoubleVector.dimension(); ++i) {
            element.appendChild(this.createNumber(abstractDoubleVector.getComponent(i)));
        }
        return element;
    }

    public Element createVector(AbstractIntegerVector abstractIntegerVector) {
        Element element = this.createElement("vector");
        for (int i = 0; i < abstractIntegerVector.dimension(); ++i) {
            element.appendChild(this.createNumber(abstractIntegerVector.getComponent(i)));
        }
        return element;
    }

    public Element createVector(AbstractComplexVector abstractComplexVector) {
        Element element = this.createElement("vector");
        for (int i = 0; i < abstractComplexVector.dimension(); ++i) {
            element.appendChild(this.createNumber(abstractComplexVector.getComponent(i)));
        }
        return element;
    }

    public Element createMatrix(AbstractDoubleMatrix abstractDoubleMatrix) {
        Element element = this.createElement("matrix");
        for (int i = 0; i < abstractDoubleMatrix.rows(); ++i) {
            Element element2 = this.createElement("matrixrow");
            for (int j = 0; j < abstractDoubleMatrix.columns(); ++j) {
                element2.appendChild(this.createNumber(abstractDoubleMatrix.getElement(i, j)));
            }
            element.appendChild(element2);
        }
        return element;
    }

    public Element createMatrix(AbstractIntegerMatrix abstractIntegerMatrix) {
        Element element = this.createElement("matrix");
        for (int i = 0; i < abstractIntegerMatrix.rows(); ++i) {
            Element element2 = this.createElement("matrixrow");
            for (int j = 0; j < abstractIntegerMatrix.columns(); ++j) {
                element2.appendChild(this.createNumber(abstractIntegerMatrix.getElement(i, j)));
            }
            element.appendChild(element2);
        }
        return element;
    }

    public Element createMatrix(AbstractComplexMatrix abstractComplexMatrix) {
        Element element = this.createElement("matrix");
        for (int i = 0; i < abstractComplexMatrix.rows(); ++i) {
            Element element2 = this.createElement("matrixrow");
            for (int j = 0; j < abstractComplexMatrix.columns(); ++j) {
                element2.appendChild(this.createNumber(abstractComplexMatrix.getElement(i, j)));
            }
            element.appendChild(element2);
        }
        return element;
    }

    public Element createSet(FiniteSet finiteSet) {
        Element element = this.createElement("set");
        Iterator iterator = finiteSet.getElements().iterator();
        while (iterator.hasNext()) {
            element.appendChild(this.createVariable(iterator.next()));
        }
        return element;
    }

    public Element createApply(String string, DocumentFragment documentFragment) {
        Element element = this.createElement("apply");
        element.appendChild(this.createElement(string));
        element.appendChild(documentFragment);
        return element;
    }

    public Element createApply(MathMLExpression mathMLExpression) {
        Element element = this.createElement("apply");
        element.appendChild(this.createElement(mathMLExpression.getOperation()));
        for (int i = 0; i < mathMLExpression.length(); ++i) {
            Object object = mathMLExpression.getArgument(i);
            if (object instanceof MathMLExpression) {
                element.appendChild(this.createApply((MathMLExpression)object));
                continue;
            }
            if (object instanceof MathDouble) {
                element.appendChild(this.createNumber(((MathDouble)object).value()));
                continue;
            }
            if (object instanceof Complex) {
                element.appendChild(this.createNumber((Complex)object));
                continue;
            }
            if (object instanceof AbstractDoubleVector) {
                element.appendChild(this.createVector((AbstractDoubleVector)object));
                continue;
            }
            if (object instanceof AbstractDoubleMatrix) {
                element.appendChild(this.createMatrix((AbstractDoubleMatrix)object));
                continue;
            }
            element.appendChild(this.createVariable(object));
        }
        return element;
    }

    public void print(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        writer.write("<!DOCTYPE " + this.getDoctype().getName() + " PUBLIC \"" + this.getDoctype().getPublicId() + "\" \"" + this.getDoctype().getSystemId() + "\">\n");
        this.printNode(writer, this.getDocumentElement(), true);
        writer.flush();
    }

    private void printNode(Writer writer, Node node, boolean bl) throws IOException {
        if (node.hasChildNodes()) {
            writer.write("<" + node.getNodeName());
            if (bl) {
                writer.write(" xmlns=\"" + node.getNamespaceURI() + "\"");
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                writer.write(" " + namedNodeMap.item(i).getNodeName() + "=\"" + namedNodeMap.item(i).getNodeValue() + "\"");
            }
            writer.write(">");
            if (node.getFirstChild().getNodeType() != 3) {
                writer.write("\n");
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.printNode(writer, nodeList.item(i), false);
            }
            writer.write("</" + node.getNodeName() + ">\n");
        } else if (node.getNodeType() == 3) {
            writer.write(node.getNodeValue());
        } else {
            writer.write("<" + node.getNodeName() + "/>");
            if (node.getNextSibling().getNodeType() != 3) {
                writer.write("\n");
            }
        }
    }
}

