/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.Mapping;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleLUCache;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleSparseVector;
import JSci.maths.vectors.DoubleVector;

public final class DoubleSparseSquareMatrix
extends AbstractDoubleSquareMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;
    private int capacityIncrement = 1;

    public DoubleSparseSquareMatrix(int n) {
        super(n);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseSquareMatrix(int n, int n2) {
        this(n);
        this.capacityIncrement = n2;
    }

    public DoubleSparseSquareMatrix(double[][] dArray) {
        super(dArray.length);
        int n;
        int n2;
        this.rows = new int[this.numRows + 1];
        int n3 = 0;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            if (dArray[n2].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (n = 0; n < this.numCols; ++n) {
                if (!(Math.abs(dArray[n2][n]) > GlobalSettings.ZERO_TOL)) continue;
                ++n3;
            }
        }
        this.elements = new double[n3];
        this.colPos = new int[n3];
        n3 = 0;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            this.rows[n2] = n3;
            for (n = 0; n < this.numCols; ++n) {
                if (!(Math.abs(dArray[n2][n]) > GlobalSettings.ZERO_TOL)) continue;
                this.elements[n3] = dArray[n2][n];
                this.colPos[n3] = n;
                ++n3;
            }
        }
        this.rows[this.numRows] = n3;
    }

    public boolean equals(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, double d) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows && this.numCols == abstractDoubleSquareMatrix.numCols) {
            if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
                return this.equals((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
            }
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.getElement(i, j) - abstractDoubleSquareMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public final boolean equals(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        return this.equals(doubleSparseSquareMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(DoubleSparseSquareMatrix doubleSparseSquareMatrix, double d) {
        if (this.numRows == doubleSparseSquareMatrix.numRows && this.numCols == doubleSparseSquareMatrix.numCols) {
            for (int i = 1; i < this.rows.length; ++i) {
                if (this.rows[i] == doubleSparseSquareMatrix.rows[i]) continue;
                return false;
            }
            double d2 = 0.0;
            for (int i = 0; i < this.rows[this.numRows]; ++i) {
                if (this.colPos[i] != doubleSparseSquareMatrix.colPos[i]) {
                    return false;
                }
                double d3 = this.elements[i] - doubleSparseSquareMatrix.elements[i];
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                nArray[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerSquareMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j);
            }
        }
        return new ComplexSquareMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3;
            for (n3 = this.rows[n]; n3 < this.rows[n + 1] && this.colPos[n3] < n2; ++n3) {
            }
            if (n3 < this.rows[n + 1] && this.colPos[n3] == n2) {
                return this.elements[n3];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3;
            for (n3 = this.rows[n]; n3 < this.rows[n + 1] && this.colPos[n3] < n2; ++n3) {
            }
            if (n3 < this.rows[n + 1] && this.colPos[n3] == n2) {
                if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                    System.arraycopy(this.elements, n3 + 1, this.elements, n3, this.rows[this.numRows] - n3 - 1);
                    System.arraycopy(this.colPos, n3 + 1, this.colPos, n3, this.rows[this.numRows] - n3 - 1);
                    int n4 = n + 1;
                    while (n4 < this.rows.length) {
                        int n5 = n4++;
                        this.rows[n5] = this.rows[n5] - 1;
                    }
                } else {
                    this.elements[n3] = d;
                }
            } else if (Math.abs(d) > GlobalSettings.ZERO_TOL) {
                if (this.rows[this.numRows] == this.elements.length) {
                    double[] dArray = this.elements;
                    int[] nArray = this.colPos;
                    this.elements = new double[dArray.length + this.capacityIncrement];
                    this.colPos = new int[nArray.length + this.capacityIncrement];
                    System.arraycopy(dArray, 0, this.elements, 0, n3);
                    System.arraycopy(nArray, 0, this.colPos, 0, n3);
                    System.arraycopy(dArray, n3, this.elements, n3 + 1, dArray.length - n3);
                    System.arraycopy(nArray, n3, this.colPos, n3 + 1, nArray.length - n3);
                } else {
                    System.arraycopy(this.elements, n3, this.elements, n3 + 1, this.rows[this.numRows] - n3);
                    System.arraycopy(this.colPos, n3, this.colPos, n3 + 1, this.rows[this.numRows] - n3);
                }
                this.elements[n3] = d;
                this.colPos[n3] = n2;
                int n6 = n + 1;
                while (n6 < this.rows.length) {
                    int n7 = n6++;
                    this.rows[n7] = this.rows[n7] + 1;
                }
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public int elementCount() {
        return this.rows[this.numRows];
    }

    public double det() {
        int[] nArray = new int[this.numRows + 1];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose(nArray);
        double d = abstractDoubleSquareMatrixArray[1].getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            d *= abstractDoubleSquareMatrixArray[1].getElement(i, i);
        }
        return d * (double)nArray[this.numRows];
    }

    public double trace() {
        double d = this.getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            d += this.getElement(i, i);
        }
        return d;
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                d2 += Math.abs(this.elements[j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            d += this.elements[i] * this.elements[i];
        }
        return Math.sqrt(d);
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.add((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + abstractDoubleSquareMatrix.getElement(i, 0);
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + abstractDoubleSquareMatrix.getElement(i, n);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + doubleSquareMatrix.matrix[i][0];
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + doubleSquareMatrix.matrix[i][n];
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix add(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows && this.numCols == doubleSparseSquareMatrix.numCols) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    doubleSparseSquareMatrix2.setElement(i, j, this.getElement(i, j) + doubleSparseSquareMatrix.getElement(i, j));
                }
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.subtract((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] - abstractDoubleSquareMatrix.getElement(i, 0);
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] - abstractDoubleSquareMatrix.getElement(i, n);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] - doubleSquareMatrix.matrix[i][0];
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] - doubleSquareMatrix.matrix[i][n];
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix subtract(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows && this.numCols == doubleSparseSquareMatrix.numCols) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    doubleSparseSquareMatrix2.setElement(i, j, this.getElement(i, j) - doubleSparseSquareMatrix.getElement(i, j));
                }
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseSquareMatrix.elements[i] = d * this.elements[i];
        }
        return doubleSparseSquareMatrix;
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseSquareMatrix.elements[i] = this.elements[i] / d;
        }
        return doubleSparseSquareMatrix;
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.numRows && this.numCols == abstractDoubleSquareMatrix.numCols) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * abstractDoubleSquareMatrix.getElement(i, this.colPos[j]);
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * doubleSquareMatrix.matrix[i][this.colPos[j]];
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.multiply((DoubleSparseVector)abstractDoubleVector);
        }
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.elements[j] * abstractDoubleVector.getComponent(this.colPos[j]);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleVector multiply(DoubleSparseVector doubleSparseVector) {
        if (this.numCols == doubleSparseVector.dimension()) {
            DoubleSparseVector doubleSparseVector2 = new DoubleSparseVector(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                double d = 0.0;
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * doubleSparseVector.getComponent(this.colPos[j]);
                }
                doubleSparseVector2.setComponent(i, d);
            }
            return doubleSparseVector2;
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.multiply((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][abstractDoubleSquareMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < abstractDoubleSquareMatrix.numCols; ++j) {
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.elements[k] * abstractDoubleSquareMatrix.getElement(this.colPos[k], j);
                    }
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < doubleSquareMatrix.numCols; ++j) {
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.elements[k] * doubleSquareMatrix.matrix[this.colPos[k]][j];
                    }
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSparseSquareMatrix multiply(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numCols == doubleSparseSquareMatrix.numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d = 0.0;
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        d += this.elements[k] * doubleSparseSquareMatrix.getElement(this.colPos[k], j);
                    }
                    doubleSparseSquareMatrix2.setElement(i, j, d);
                }
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            doubleSparseSquareMatrix.setElement(0, i, this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                doubleSparseSquareMatrix.setElement(j, i, this.getElement(i, j));
            }
        }
        return doubleSparseSquareMatrix;
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose_cache(nArray);
        if (abstractDoubleSquareMatrixArray != null) {
            return abstractDoubleSquareMatrixArray;
        }
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        for (n = 0; n < this.numRows; ++n) {
            nArray[n] = n;
        }
        nArray[this.numRows] = 1;
        for (n = 0; n < this.numCols; ++n) {
            int n2;
            for (int i = 0; i < n; ++i) {
                double d = this.getElement(nArray[i], n);
                for (n2 = 0; n2 < i; ++n2) {
                    d -= dArray2[i][n2] * dArray2[n2][n];
                }
                dArray2[i][n] = d;
            }
            double d = 0.0;
            int n3 = n;
            for (n2 = n; n2 < this.numRows; ++n2) {
                double d2 = this.getElement(nArray[n2], n);
                for (int i = 0; i < n; ++i) {
                    d2 -= dArray2[n2][i] * dArray2[i][n];
                }
                dArray2[n2][n] = d2;
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
                n3 = n2;
            }
            if (n3 != n) {
                double[] dArray3 = dArray2[n];
                dArray2[n] = dArray2[n3];
                dArray2[n3] = dArray3;
                int n4 = nArray[n];
                nArray[n] = nArray[n3];
                nArray[n3] = n4;
                nArray[this.numRows] = -nArray[this.numRows];
            }
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                double[] dArray4 = dArray2[n2];
                int n5 = n;
                dArray4[n5] = dArray4[n5] / dArray2[n][n];
            }
        }
        for (n = 0; n < this.numCols; ++n) {
            dArray[n][n] = 1.0;
            for (int i = n + 1; i < this.numRows; ++i) {
                dArray[i][n] = dArray2[i][n];
                dArray2[i][n] = 0.0;
            }
        }
        DoubleSquareMatrix doubleSquareMatrix = new DoubleSquareMatrix(dArray);
        DoubleSquareMatrix doubleSquareMatrix2 = new DoubleSquareMatrix(dArray2);
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.luCache = new DoubleLUCache(doubleSquareMatrix, doubleSquareMatrix2, nArray2);
        return new DoubleSquareMatrix[]{doubleSquareMatrix, doubleSquareMatrix2};
    }

    public AbstractDoubleSquareMatrix[] luDecompose() {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (n2 = 0; n2 < this.numCols; ++n2) {
            int n3;
            double d;
            for (n = 0; n < n2; ++n) {
                d = this.getElement(n, n2);
                for (n3 = 0; n3 < n; ++n3) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                }
                dArray2[n][n2] = d;
            }
            for (n = n2; n < this.numRows; ++n) {
                d = this.getElement(n, n2);
                for (n3 = 0; n3 < n2; ++n3) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                }
                dArray2[n][n2] = d;
            }
            for (n = n2 + 1; n < this.numRows; ++n) {
                double[] dArray3 = dArray2[n];
                int n4 = n2;
                dArray3[n4] = dArray3[n4] / dArray2[n2][n2];
            }
        }
        for (n2 = 0; n2 < this.numCols; ++n2) {
            dArray[n2][n2] = 1.0;
            for (n = n2 + 1; n < this.numRows; ++n) {
                dArray[n][n2] = dArray2[n][n2];
                dArray2[n][n2] = 0.0;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray2[0][0] = d;
        dArray[0][0] = d;
        for (n = 1; n < this.numRows; ++n) {
            double d2 = this.getElement(n, 0) / dArray[0][0];
            dArray2[0][n] = d2;
            dArray[n][0] = d2;
        }
        for (n = 1; n < this.numCols; ++n) {
            int n2;
            double d3 = this.getElement(n, n);
            for (n2 = 0; n2 < n; ++n2) {
                d3 -= dArray[n][n2] * dArray[n][n2];
            }
            double d4 = Math.sqrt(d3);
            dArray2[n][n] = d4;
            dArray[n][n] = d4;
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                d3 = this.getElement(n2, n);
                for (int i = 0; i < n2; ++i) {
                    d3 -= dArray[n][i] * dArray2[i][n2];
                }
                double d5 = d3 / dArray2[n][n];
                dArray2[n][n2] = d5;
                dArray[n2][n] = d5;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseSquareMatrix.elements[i] = mapping.map(this.elements[i]);
        }
        return doubleSparseSquareMatrix;
    }
}

