/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.jna.JnaNativeFunction;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.jna.JnaNativeInterface;

public class JnaNativeLibrary
implements INativeLibrary {
    private final NativeLibrary library;
    private final JnaNativeInterface nativeInterface;

    public JnaNativeLibrary(JnaNativeInterface nativeInterface, String name) {
        this.nativeInterface = nativeInterface;
        for (String path : nativeInterface.getSearchPaths()) {
            NativeLibrary.addSearchPath((String)name, (String)path);
        }
        this.library = NativeLibrary.getInstance((String)name);
    }

    public INativeFunction getFunction(String name) {
        Function function = this.getLibrary().getFunction(name);
        return new JnaNativeFunction(function);
    }

    public INativeHandle getGlobal(String symbolName) {
        Pointer pointer = this.getLibrary().getGlobalVariableAddress(symbolName);
        return new JnaNativeHandle(pointer);
    }

    protected NativeLibrary getLibrary() {
        return this.library;
    }

    protected JnaNativeInterface getNativeInterface() {
        return this.nativeInterface;
    }
}

