/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeReference;

public abstract class NativeObject
implements INativeObject {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_INT = 4;
    public static final int SHIFT_INT = 2;
    public static final int SIZE_LONGLONG = 8;
    public static final int SHIFT_LONGLONG = 3;
    public static final int SIZE_LONG = NativeInterface.get().longSize();
    public static final int SHIFT_LONG = SIZE_LONG == 4 ? 2 : 3;
    public static final int SIZE_PTR = NativeInterface.get().pointerSize();
    public static final int SIZE_SHORT = 2;
    public static boolean DEBUG = true;
    protected INativeHandle handle;

    protected NativeObject() {
    }

    protected NativeObject(INativeHandle handle) {
        this.handle = handle;
    }

    protected void allocate() {
        int size = this.getByteCount();
        this.handle = NativeInterface.get().allocate(size);
    }

    public INativeObject cast(INativeType declaration) {
        return declaration.createNative(this.handle);
    }

    public INativeObject createReference() {
        NativeReference ref = NativeReference.create(this.getNativeType());
        ref.setValue(this);
        return ref;
    }

    public byte getByte(int index) {
        return this.handle.getByte(index);
    }

    public byte[] getByteArray(int index, int count) {
        return this.handle.getByteArray(index, count);
    }

    public abstract int getByteCount();

    public byte[] getBytes() {
        return this.handle.getByteArray(0, this.getByteCount());
    }

    public long getCLong(int index) {
        return this.handle.getCLong(index);
    }

    public int getInt(int index) {
        return this.handle.getInt(index);
    }

    public INativeHandle getNativeHandle() {
        return this.handle;
    }

    public INativeHandle getNativeHandle(int index) {
        return this.handle.getNativeHandle(index);
    }

    public abstract INativeType getNativeType();

    public short getShort(int index) {
        return this.handle.getShort(index);
    }

    public String getString(int index) {
        return this.handle.getString(index);
    }

    public String getWideString(int index) {
        return this.handle.getWideString(index);
    }

    public boolean isNull() {
        return this.handle == null || this.handle.getAddress() == 0L;
    }

    public void setByte(int index, byte value) {
        this.handle.setByte(index, value);
    }

    public void setByteArray(int index, byte[] value, int valueOffset, int valueCount) {
        this.handle.setByteArray(index, value, valueOffset, valueCount);
    }

    public void setCLong(int index, long value) {
        this.handle.setCLong(index, value);
    }

    public void setInt(int index, int value) {
        this.handle.setInt(index, value);
    }

    public void setNativeHandle(int index, INativeHandle value) {
        this.handle.setNativeHandle(index, value);
    }

    public void setShort(int index, short value) {
        this.handle.setShort(index, value);
    }

    public void setString(int index, String value) {
        this.handle.setString(index, value);
    }

    public void setWideString(int index, String value) {
        this.handle.setWideString(index, value);
    }

    public String toNestedString() {
        return this.toString();
    }
}

