/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.MacOSRomanEncoding;
import de.intarsys.pdf.encoding.StandardEncoding;
import de.intarsys.pdf.font.CIDFontType0;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.DifferenceEncoding;
import de.intarsys.pdf.font.IdentityCMap;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontMMType1;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class PDFont
extends PDObject {
    private static final Attribute ATTR_FONTFAMILY = new Attribute("fontfamily");
    private static final Attribute ATTR_FONTNAME = new Attribute("fontname");
    private static final Attribute ATTR_FONTSTYLE = new Attribute("fontstyle");
    public static final COSName CN_Subtype_CIDFontType0 = COSName.constant("CIDFontType0");
    public static final COSName CN_Subtype_CIDFontType2 = COSName.constant("CIDFontType2");
    public static final COSName CN_Subtype_MMType1 = COSName.constant("MMType1");
    public static final COSName CN_Subtype_TrueType = COSName.constant("TrueType");
    public static final COSName CN_Subtype_Type0 = COSName.constant("Type0");
    public static final COSName CN_Subtype_Type1 = COSName.constant("Type1");
    public static final COSName CN_Subtype_Type3 = COSName.constant("Type3");
    public static final COSName CN_Type_Font = COSName.constant("Font");
    public static final COSName DK_BaseFont = COSName.constant("BaseFont");
    public static final COSName DK_Encoding = COSName.constant("Encoding");
    public static final COSName DK_FirstChar = COSName.constant("FirstChar");
    public static final COSName DK_FontDescriptor = COSName.constant("FontDescriptor");
    public static final COSName DK_LastChar = COSName.constant("LastChar");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final COSName DK_ToUnicode = COSName.constant("ToUnicode");
    public static final COSName DK_Widths = COSName.constant("Widths");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static CMap UNDEFINED = new IdentityCMap();
    private Encoding cachedEncoding;
    private PDFontDescriptor cachedFontDescriptor;
    private CMap cachedToUnicode = UNDEFINED;

    public static String getFontFamilyName(String name) {
        int posComma;
        int posMinus;
        if (name == null) {
            return null;
        }
        int posPlus = name.indexOf(43);
        if (posPlus > 0) {
            name = name.substring(posPlus + 1);
        }
        if ((posMinus = name.lastIndexOf(45)) > 0) {
            name = name.substring(0, posMinus);
        }
        if ((posComma = name.indexOf(44)) > 0) {
            name = name.substring(0, posComma);
        }
        return name;
    }

    public static String getFontName(String name) {
        if (name == null) {
            return null;
        }
        int posPlus = name.indexOf(43);
        if (posPlus > 0) {
            name = name.substring(posPlus + 1);
        }
        return name;
    }

    public static PDFontStyle getFontStyle(String name) {
        int posComma;
        if (name == null) {
            return PDFontStyle.REGULAR;
        }
        int posMinus = name.lastIndexOf(45);
        if (posMinus > 0) {
            name = name.substring(posMinus + 1);
        }
        if ((posComma = name.indexOf(44)) > 0) {
            name = name.substring(posComma + 1).trim();
        }
        return PDFontStyle.getFontStyle(name);
    }

    protected PDFont(COSObject object) {
        super(object);
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Font;
    }

    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return null;
    }

    protected int[] createBuiltInWidths(int[] result) {
        return result;
    }

    protected int[] createDeclaredWidths(int[] result, COSArray array) {
        int i = this.getFirstChar();
        Iterator it = array.iterator();
        while (it.hasNext()) {
            COSNumber width = ((COSObject)it.next()).asNumber();
            if (width != null) {
                result[i] = width.intValue();
            }
            ++i;
        }
        return result;
    }

    protected Encoding createDefaultEncoding() {
        return StandardEncoding.UNIQUE;
    }

    protected Encoding createEncoding() {
        COSObject encoding = this.cosGetField(DK_Encoding);
        if (encoding.isNull()) {
            return this.createDefaultEncoding();
        }
        if (encoding instanceof COSName) {
            return Encoding.createNamed((COSName)encoding);
        }
        if (encoding instanceof COSDictionary) {
            return DifferenceEncoding.create((COSDictionary)encoding, this);
        }
        throw new IllegalArgumentException("encoding not supported");
    }

    protected int createFirstChar() {
        return 0;
    }

    protected PDFontDescriptor createFontDescriptor() {
        COSObject base = this.cosGetField(DK_FontDescriptor);
        if (base.isNull()) {
            return this.createBuiltinFontDescriptor();
        }
        return (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createFromCos(base);
    }

    protected int createLastChar() {
        return 255;
    }

    protected int[] createWidths() {
        int[] result = new int[256];
        int missing = this.getMissingWidth();
        int i = 0;
        while (i < 256) {
            result[i] = missing;
            ++i;
        }
        COSArray base = this.cosGetField(DK_Widths).asArray();
        if (base == null) {
            return this.createBuiltInWidths(result);
        }
        return this.createDeclaredWidths(result, base);
    }

    public void dumpFontFile(File file) {
        block9: {
            PDFontDescriptorEmbedded fd = (PDFontDescriptorEmbedded)this.getFontDescriptor();
            if (fd == null) {
                return;
            }
            byte[] data = fd.getFontFile();
            if (data == null) {
                data = fd.getFontFile2();
            }
            if (data == null) {
                data = fd.getFontFile3();
            }
            if (data == null) {
                return;
            }
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(file);
                    os.write(data);
                }
                catch (Exception exception) {
                    StreamTools.close(os);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                StreamTools.close(os);
                throw throwable;
            }
            StreamTools.close((OutputStream)os);
        }
    }

    public COSName getBaseFont() {
        return this.cosGetField(DK_BaseFont).asName();
    }

    public Encoding getEncoding() {
        if (this.cachedEncoding == null) {
            this.cachedEncoding = this.createEncoding();
        }
        return this.cachedEncoding;
    }

    public int getFirstChar() {
        COSInteger base = this.cosGetField(DK_FirstChar).asInteger();
        if (base == null) {
            return this.createFirstChar();
        }
        return ((COSNumber)base).intValue();
    }

    public PDFontDescriptor getFontDescriptor() {
        if (this.cachedFontDescriptor == null) {
            this.cachedFontDescriptor = this.createFontDescriptor();
        }
        return this.cachedFontDescriptor;
    }

    public String getFontFamilyName() {
        try {
            String result;
            PDFontDescriptor fontDescriptor = this.getFontDescriptor();
            if (fontDescriptor != null && (result = fontDescriptor.getFontFamily()) != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PDFont.getFontFamilyName(this.getBaseFont().stringValue());
    }

    public String getFontName() {
        return this.getBaseFont().stringValue();
    }

    public String getFontNameNormalized() {
        return PDFont.getFontName(this.getFontName());
    }

    public PDFontStyle getFontStyle() {
        return PDFont.getFontStyle(this.getBaseFont().stringValue());
    }

    public abstract String getFontType();

    public abstract PDGlyphs getGlyphsEncoded(int var1);

    public abstract int getGlyphWidthEncoded(int var1);

    public int getLastChar() {
        COSInteger base = this.cosGetField(DK_LastChar).asInteger();
        if (base == null) {
            return this.createLastChar();
        }
        return ((COSNumber)base).intValue();
    }

    public String getLookupFontFamilyName() {
        String result = (String)this.getAttribute(ATTR_FONTFAMILY);
        if (result == null) {
            result = this.getFontFamilyName();
            this.setAttribute(ATTR_FONTFAMILY, result);
        }
        return result;
    }

    public String getLookupFontName() {
        String result = (String)this.getAttribute(ATTR_FONTNAME);
        if (result == null) {
            result = this.getFontNameNormalized();
            this.setAttribute(ATTR_FONTNAME, result);
        }
        return result;
    }

    public PDFontStyle getLookupFontStyle() {
        PDFontStyle result = (PDFontStyle)this.getAttribute(ATTR_FONTSTYLE);
        if (result == null) {
            result = this.getFontStyle();
            this.setAttribute(ATTR_FONTSTYLE, result);
        }
        return result;
    }

    public int getMacintoshRomanCode(int codePoint) {
        String glyphName = this.getEncoding().getGlyphName(codePoint);
        return MacOSRomanEncoding.UNIQUE.getEncoded(glyphName);
    }

    public int getMissingWidth() {
        if (this.getFontDescriptor() == null) {
            return 0;
        }
        return this.getFontDescriptor().getMissingWidth();
    }

    public abstract PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream var1) throws IOException;

    public CMap getToUnicode() {
        if (this.cachedToUnicode == UNDEFINED) {
            try {
                this.cachedToUnicode = (CMap)CMap.META.createFromCos(this.cosGetField(DK_ToUnicode));
            }
            catch (RuntimeException e) {
                this.cachedToUnicode = null;
                throw e;
            }
        }
        return this.cachedToUnicode;
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedEncoding = null;
        this.cachedFontDescriptor = null;
        this.cachedToUnicode = UNDEFINED;
    }

    public boolean isEmbedded() {
        COSObject base = this.cosGetField(DK_FontDescriptor);
        if (base.isNull() && !(this instanceof PDFontType0)) {
            return false;
        }
        if (this.getFontDescriptor() == null) {
            return false;
        }
        if (this.getFontDescriptor().getFontFile() != null) {
            return true;
        }
        if (this.getFontDescriptor().getFontFile2() != null) {
            return true;
        }
        return this.getFontDescriptor().getFontFile3() != null;
    }

    public boolean isStandardFont() {
        return false;
    }

    public boolean isSubset() {
        byte[] name = this.getBaseFont().byteValue();
        if (name.length > 7) {
            return name[6] == 43;
        }
        if (this.getFirstChar() > 32) {
            return true;
        }
        return this.getLastChar() < 128;
    }

    public void setBaseFont(String name) {
        this.setFieldName(DK_BaseFont, name);
    }

    public void setEncoding(Encoding newFontEncoding) {
        this.cachedEncoding = newFontEncoding;
        if (newFontEncoding != null) {
            COSObject ref = this.cachedEncoding.cosGetObject();
            if (ref == null || ref.isNull()) {
                this.cosRemoveField(DK_Encoding);
            } else {
                this.cosSetField(DK_Encoding, ref);
            }
        } else {
            this.cosRemoveField(DK_Encoding);
        }
    }

    public void setFontDescriptor(PDFontDescriptor descriptor) {
        this.cachedFontDescriptor = descriptor;
        this.setFieldObject(DK_FontDescriptor, this.cachedFontDescriptor);
    }

    public void setLookupFontFamilyName(String name) {
        if (name == null) {
            return;
        }
        this.setAttribute(ATTR_FONTFAMILY, name);
    }

    public void setLookupFontName(String name) {
        if (name == null) {
            return;
        }
        this.setAttribute(ATTR_FONTNAME, name);
    }

    public void setLookupFontStyle(PDFontStyle newStyle) {
        if (newStyle == null) {
            return;
        }
        this.setAttribute(ATTR_FONTSTYLE, newStyle);
    }

    public void setToUnicode(CMap newToUnicode) {
        this.cachedToUnicode = UNDEFINED;
        this.setFieldObject(DK_ToUnicode, newToUnicode);
    }

    public String toString() {
        return String.valueOf(this.cosGetSubtype().stringValue()) + "-Font " + this.getBaseFont().toString() + " (" + this.getEncoding() + ")";
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSDictionary dict = object.asDictionary();
            if (dict == null) {
                throw new IllegalArgumentException("font object is not a COSDictionary as required");
            }
            COSName type = dict.get(DK_Type).asName();
            if (type == null) {
                throw new IllegalArgumentException("Dictionary has no type");
            }
            if (!type.equals(CN_Type_Font)) {
                throw new IllegalArgumentException("type <" + type + "> is not a valid font type");
            }
            COSName subtype = dict.get(DK_Subtype).asName();
            if (subtype == null) {
                throw new IllegalArgumentException("font not identified by subtype");
            }
            if (subtype.equals(CN_Subtype_Type1)) {
                return PDFontType1.META;
            }
            if (subtype.equals(CN_Subtype_TrueType)) {
                if (dict.get(DK_FontDescriptor).isNull()) {
                    return PDFontType1.META;
                }
                return PDFontTrueType.META;
            }
            if (subtype.equals(CN_Subtype_MMType1)) {
                return PDFontMMType1.META;
            }
            if (subtype.equals(CN_Subtype_Type0)) {
                return PDFontType0.META;
            }
            if (subtype.equals(CN_Subtype_Type3)) {
                return PDFontType3.META;
            }
            if (subtype.equals(CN_Subtype_CIDFontType0)) {
                return CIDFontType0.META;
            }
            if (subtype.equals(CN_Subtype_CIDFontType2)) {
                return CIDFontType2.META;
            }
            throw new IllegalArgumentException("font subtype <" + subtype + "> not supported");
        }

        public Class getRootClass() {
            return PDFont.class;
        }
    }
}

