/*
 * Decompiled with CFR 0.152.
 */
package moa.options;

import java.io.File;
import javax.swing.JComponent;
import moa.gui.ClassOptionEditComponent;
import moa.options.AbstractClassOption;
import moa.options.Option;
import moa.options.OptionHandler;
import moa.options.Options;
import moa.tasks.Task;

public class ClassOption
extends AbstractClassOption {
    private static final long serialVersionUID = 1L;

    public ClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString);
    }

    public ClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString, String nullString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString, nullString);
    }

    @Override
    public String getValueAsCLIString() {
        if (this.currentValue == null && this.nullString != null) {
            return this.nullString;
        }
        return ClassOption.objectToCLIString(this.currentValue, this.requiredType);
    }

    @Override
    public void setValueViaCLIString(String s) {
        if (this.nullString != null && (s == null || s.length() == 0 || s.equals(this.nullString))) {
            this.currentValue = null;
        } else {
            try {
                this.currentValue = ClassOption.cliStringToObject(s, this.requiredType, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problems with option: " + this.getName(), e);
            }
        }
    }

    public static String objectToCLIString(Object obj, Class<?> requiredType) {
        String subOptions;
        if (obj == null) {
            return "";
        }
        if (obj instanceof File) {
            return "file:" + ((File)obj).getPath();
        }
        if (obj instanceof String) {
            return "inmem:" + obj;
        }
        String className = ClassOption.classToCLIString(obj.getClass(), requiredType);
        if (obj instanceof OptionHandler && (subOptions = ((OptionHandler)obj).getOptions().getAsCLIString()).length() > 0) {
            return className + " " + subOptions;
        }
        return className;
    }

    public static Object cliStringToObject(String cliString, Class<?> requiredType, Option[] externalOptions) throws Exception {
        Object classInstance;
        Class<?> classObject;
        String classOptions;
        String className;
        if (cliString.startsWith("file:")) {
            return new File(cliString.substring("file:".length()));
        }
        if (cliString.startsWith("inmem:")) {
            return cliString.substring("inmem:".length());
        }
        int firstSpaceIndex = (cliString = cliString.trim()).indexOf(32, 0);
        if (firstSpaceIndex > 0) {
            className = cliString.substring(0, firstSpaceIndex);
            classOptions = cliString.substring(firstSpaceIndex + 1, cliString.length());
            classOptions = classOptions.trim();
        } else {
            className = cliString;
            classOptions = "";
        }
        try {
            classObject = Class.forName(className);
        }
        catch (Throwable t1) {
            try {
                classObject = Class.forName(requiredType.getPackage().getName() + "." + className);
            }
            catch (Throwable t2) {
                try {
                    classObject = Class.forName(Task.class.getPackage().getName() + "." + className);
                }
                catch (Throwable t3) {
                    throw new Exception("Class not found: " + className);
                }
            }
        }
        try {
            classInstance = classObject.newInstance();
        }
        catch (Exception ex) {
            throw new Exception("Problem creating instance of class: " + className, ex);
        }
        if (requiredType.isInstance(classInstance) || classInstance instanceof Task && requiredType.isAssignableFrom(((Task)classInstance).getTaskResultType())) {
            Options options = new Options();
            if (externalOptions != null) {
                for (Option option : externalOptions) {
                    options.addOption(option);
                }
            }
            if (classInstance instanceof OptionHandler) {
                Option[] objectOptions;
                for (Option option : objectOptions = ((OptionHandler)classInstance).getOptions().getOptionArray()) {
                    options.addOption(option);
                }
            }
            try {
                options.setViaCLIString(classOptions);
            }
            catch (Exception ex) {
                throw new Exception("Problem with options to '" + className + "'." + "\n\nValid options for " + className + ":\n" + ((OptionHandler)classInstance).getOptions().getHelpString(), ex);
            }
            finally {
                options.removeAllOptions();
            }
        } else {
            throw new Exception("Class named '" + className + "' is not an instance of " + requiredType.getName() + ".");
        }
        return classInstance;
    }

    @Override
    public JComponent getEditComponent() {
        return new ClassOptionEditComponent(this);
    }
}

