/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.core.AutoExpandVector;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.gui.visualization.DataPoint;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.streams.clustering.ClusterEvent;
import moa.streams.clustering.ClusterEventListener;
import moa.streams.clustering.ClusteringStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class RandomRBFGeneratorEvents
extends ClusteringStream {
    private transient Vector listeners;
    private static final long serialVersionUID = 1L;
    public IntOption modelRandomSeedOption = new IntOption("modelRandomSeed", 'm', "Seed for random generation of model.", 1);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 5);
    public IntOption numClusterOption = new IntOption("numCluster", 'K', "The average number of centroids in the model.", 5, 1, Integer.MAX_VALUE);
    public IntOption numClusterRangeOption = new IntOption("numClusterRange", 'k', "Deviation of the number of centroids in the model.", 3, 0, Integer.MAX_VALUE);
    public FloatOption kernelRadiiOption = new FloatOption("kernelRadius", 'R', "The average radii of the centroids in the model.", 0.07, 0.0, 1.0);
    public FloatOption kernelRadiiRangeOption = new FloatOption("kernelRadiusRange", 'r', "Deviation of average radii of the centroids in the model.", 0.0, 0.0, 1.0);
    public FloatOption densityRangeOption = new FloatOption("densityRange", 'd', "Offset of the average weight a cluster has. Value of 0 means all cluster contain the same amount of points.", 0.0, 0.0, 1.0);
    public IntOption speedOption = new IntOption("speed", 'V', "Kernels move a predefined distance of 0.01 every X points", 500, 1, Integer.MAX_VALUE);
    public IntOption speedRangeOption = new IntOption("speedRange", 'v', "Speed/Velocity point offset", 0, 0, Integer.MAX_VALUE);
    public FloatOption noiseLevelOption = new FloatOption("noiseLevel", 'N', "Noise level", 0.1, 0.0, 1.0);
    public FlagOption noiseInClusterOption = new FlagOption("noiseInCluster", 'n', "Allow noise to be placed within a cluster");
    public IntOption eventFrequencyOption = new IntOption("eventFrequency", 'E', "Event frequency. Enable at least one of the events below and set numClusterRange!", 30000, 0, Integer.MAX_VALUE);
    public FlagOption eventMergeSplitOption = new FlagOption("eventMergeSplitOption", 'M', "Enable merging and splitting of clusters. Set eventFrequency and numClusterRange!");
    public FlagOption eventDeleteCreateOption = new FlagOption("eventDeleteCreate", 'C', "Enable emering and disapperaing of clusters. Set eventFrequency and numClusterRange!");
    private double merge_threshold = 0.7;
    private int kernelMovePointFrequency = 10;
    private double maxDistanceMoveThresholdByStep = 0.01;
    private int maxOverlapFitRuns = 50;
    private double eventFrequencyRange = 0.0;
    private boolean debug = false;
    private AutoExpandVector<GeneratorCluster> kernels;
    protected Random instanceRandom;
    protected InstancesHeader streamHeader;
    private int numGeneratedInstances;
    private int numActiveKernels;
    private int nextEventCounter;
    private int nextEventChoice = -1;
    private int clusterIdCounter;
    private GeneratorCluster mergeClusterA;
    private GeneratorCluster mergeClusterB;
    private boolean mergeKernelsOverlapping = false;

    public RandomRBFGeneratorEvents() {
        this.noiseInClusterOption.set();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Preparing random RBF...", -1.0);
        this.generateHeader();
        this.restart();
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextEventCounter = this.eventFrequencyOption.getValue();
        this.nextEventChoice = this.getNextEvent();
        this.numActiveKernels = 0;
        this.numGeneratedInstances = 0;
        this.clusterIdCounter = 0;
        this.mergeClusterB = null;
        this.mergeClusterA = null;
        this.kernels = new AutoExpandVector();
        this.initKernels();
    }

    protected void generateHeader() {
        FastVector attributes = new FastVector();
        for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
            attributes.addElement((Object)new Attribute("att" + (i + 1)));
        }
        FastVector classLabels = new FastVector();
        for (int i = 0; i < this.numClusterOption.getValue(); ++i) {
            classLabels.addElement((Object)("class" + (i + 1)));
        }
        attributes.addElement((Object)new Attribute("class", (List)classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
    }

    protected void initKernels() {
        for (int i = 0; i < this.numClusterOption.getValue(); ++i) {
            this.kernels.add(new GeneratorCluster(this.clusterIdCounter));
            ++this.numActiveKernels;
            ++this.clusterIdCounter;
        }
        this.normalizeWeights();
    }

    @Override
    public Instance nextInstance() {
        ++this.numGeneratedInstances;
        this.eventScheduler();
        double[] values_new = new double[this.numAttsOption.getValue() + 1];
        double[] values = null;
        int clusterChoice = -1;
        if (this.instanceRandom.nextDouble() > this.noiseLevelOption.getValue()) {
            clusterChoice = this.chooseWeightedElement();
            values = this.kernels.get((int)clusterChoice).generator.sample(this.instanceRandom).toDoubleArray();
        } else {
            values = this.getNoisePoint();
        }
        if (Double.isNaN(values[0])) {
            System.out.println("Instance corrupted:" + this.numGeneratedInstances);
        }
        System.arraycopy(values, 0, values_new, 0, values.length);
        DenseInstance inst = new DenseInstance(1.0, values_new);
        inst.setDataset((Instances)this.getHeader());
        if (clusterChoice == -1) {
            inst.setClassValue(-1.0);
        } else {
            inst.setClassValue(this.kernels.get((int)clusterChoice).generator.getId());
            this.kernels.get(clusterChoice).addInstance((Instance)inst);
        }
        return inst;
    }

    public Clustering getGeneratingClusters() {
        Clustering clustering = new Clustering();
        for (int c = 0; c < this.kernels.size(); ++c) {
            clustering.add(this.kernels.get((int)c).generator);
        }
        return clustering;
    }

    public Clustering getMicroClustering() {
        Clustering clustering = new Clustering();
        int id = 0;
        for (int c = 0; c < this.kernels.size(); ++c) {
            for (int m = 0; m < this.kernels.get((int)c).microClusters.size(); ++m) {
                this.kernels.get((int)c).microClusters.get(m).setId(id);
                this.kernels.get((int)c).microClusters.get(m).setGroundTruth(this.kernels.get((int)c).generator.getId());
                clustering.add(this.kernels.get((int)c).microClusters.get(m));
                ++id;
            }
        }
        return clustering;
    }

    private void eventScheduler() {
        int i;
        for (i = 0; i < this.kernels.size(); ++i) {
            this.kernels.get(i).updateKernel();
        }
        --this.nextEventCounter;
        if (this.nextEventCounter % this.kernelMovePointFrequency == 0) {
            for (i = 0; i < this.kernels.size(); ++i) {
                this.kernels.get(i).move();
            }
        }
        if (this.eventFrequencyOption.getValue() == 0) {
            return;
        }
        String type = "";
        String message = "";
        boolean eventFinished = false;
        switch (this.nextEventChoice) {
            case 0: {
                if (this.numActiveKernels > 1 && this.numActiveKernels > this.numClusterOption.getValue() - this.numClusterRangeOption.getValue()) {
                    message = this.mergeKernels(this.nextEventCounter);
                    type = "Merge";
                }
                if (this.mergeClusterA != null || this.mergeClusterB != null || !message.startsWith("Clusters merging")) break;
                eventFinished = true;
                break;
            }
            case 1: {
                if (this.nextEventCounter > 0) break;
                if (this.numActiveKernels < this.numClusterOption.getValue() + this.numClusterRangeOption.getValue()) {
                    type = "Split";
                    message = this.splitKernel();
                }
                eventFinished = true;
                break;
            }
            case 2: {
                if (this.nextEventCounter > 0) break;
                if (this.numActiveKernels > 1 && this.numActiveKernels > this.numClusterOption.getValue() - this.numClusterRangeOption.getValue()) {
                    message = this.fadeOut();
                    type = "Delete";
                }
                eventFinished = true;
                break;
            }
            case 3: {
                if (this.nextEventCounter > 0) break;
                if (this.numActiveKernels < this.numClusterOption.getValue() + this.numClusterRangeOption.getValue()) {
                    message = this.fadeIn();
                    type = "Create";
                }
                eventFinished = true;
            }
        }
        if (eventFinished) {
            this.nextEventCounter = (int)((double)this.eventFrequencyOption.getValue() + (double)((this.instanceRandom.nextBoolean() ? -1 : 1) * this.eventFrequencyOption.getValue()) * this.eventFrequencyRange * this.instanceRandom.nextDouble());
            this.nextEventChoice = this.getNextEvent();
        }
        if (!message.isEmpty()) {
            message = message + " (numKernels = " + this.numActiveKernels + " at " + this.numGeneratedInstances + ")";
            if (!type.equals("Merge") || message.startsWith("Clusters merging")) {
                this.fireClusterChange(this.numGeneratedInstances, type, message);
            }
        }
    }

    private int getNextEvent() {
        boolean upperLimit;
        int choice = -1;
        boolean lowerLimit = this.numActiveKernels <= this.numClusterOption.getValue() - this.numClusterRangeOption.getValue();
        boolean bl = upperLimit = this.numActiveKernels >= this.numClusterOption.getValue() + this.numClusterRangeOption.getValue();
        if (!lowerLimit || !upperLimit) {
            int mode = -1;
            if (this.eventDeleteCreateOption.isSet() && this.eventMergeSplitOption.isSet()) {
                mode = this.instanceRandom.nextInt(2);
            }
            if (mode == 0 || mode == -1 && this.eventMergeSplitOption.isSet()) {
                choice = !lowerLimit && !upperLimit ? this.instanceRandom.nextInt(2) : (lowerLimit ? 1 : 0);
            }
            if (mode == 1 || mode == -1 && this.eventDeleteCreateOption.isSet()) {
                choice = !lowerLimit && !upperLimit ? this.instanceRandom.nextInt(2) + 2 : (lowerLimit ? 3 : 2);
            }
        }
        return choice;
    }

    private String fadeOut() {
        int id = this.instanceRandom.nextInt(this.kernels.size());
        while (this.kernels.get((int)id).kill != -1) {
            id = this.instanceRandom.nextInt(this.kernels.size());
        }
        String message = this.kernels.get(id).fadeOut();
        return message;
    }

    private String fadeIn() {
        GeneratorCluster gc = new GeneratorCluster(this.clusterIdCounter++);
        this.kernels.add(gc);
        ++this.numActiveKernels;
        this.normalizeWeights();
        return "Creating new cluster";
    }

    private String changeWeight(boolean increase) {
        double changeRate = 0.1;
        int id = this.instanceRandom.nextInt(this.kernels.size());
        while (this.kernels.get((int)id).kill != -1) {
            id = this.instanceRandom.nextInt(this.kernels.size());
        }
        int sign = 1;
        if (!increase) {
            sign = -1;
        }
        double weight_old = this.kernels.get((int)id).generator.getWeight();
        double delta = (double)(sign * this.numActiveKernels) * this.instanceRandom.nextDouble() * changeRate;
        this.kernels.get((int)id).generator.setWeight(weight_old + delta);
        this.normalizeWeights();
        String message = increase ? "Increase " : "Decrease ";
        message = message + " weight on Cluster " + id + " from " + weight_old + " to " + (weight_old + delta);
        return message;
    }

    private String changeRadius(boolean increase) {
        double r_old;
        double r_new;
        double maxChangeRate = 0.1;
        int id = this.instanceRandom.nextInt(this.kernels.size());
        while (this.kernels.get((int)id).kill != -1) {
            id = this.instanceRandom.nextInt(this.kernels.size());
        }
        int sign = 1;
        if (!increase) {
            sign = -1;
        }
        if ((r_new = (r_old = this.kernels.get((int)id).generator.getRadius()) + (double)sign * r_old * this.instanceRandom.nextDouble() * maxChangeRate) >= 0.5) {
            return "Radius to big";
        }
        this.kernels.get((int)id).generator.setRadius(r_new);
        String message = increase ? "Increase " : "Decrease ";
        message = message + " radius on Cluster " + id + " from " + r_old + " to " + r_new;
        return message;
    }

    private String splitKernel() {
        int id = this.instanceRandom.nextInt(this.kernels.size());
        while (this.kernels.get((int)id).kill != -1) {
            id = this.instanceRandom.nextInt(this.kernels.size());
        }
        String message = this.kernels.get(id).splitKernel();
        return message;
    }

    private String mergeKernels(int steps) {
        if (this.numActiveKernels > 1 && this.mergeClusterA == null && this.mergeClusterB == null) {
            double diseredDist = (double)(steps / this.speedOption.getValue()) * this.maxDistanceMoveThresholdByStep;
            double minDist = Double.MAX_VALUE;
            for (int i = 0; i < this.kernels.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double kernelDist;
                    double d;
                    if (this.kernels.get((int)i).kill != -1 || this.kernels.get((int)j).kill != -1 || !(Math.abs(d = (kernelDist = this.kernels.get((int)i).generator.getCenterDistance(this.kernels.get((int)j).generator)) - 2.0 * diseredDist) < minDist) || minDist == Double.MAX_VALUE && !(d > 0.0) && !(Math.abs(d) < 0.001)) continue;
                    minDist = Math.abs(d);
                    this.mergeClusterA = this.kernels.get(i);
                    this.mergeClusterB = this.kernels.get(j);
                }
            }
            if (this.mergeClusterA != null && this.mergeClusterB != null) {
                double[] merge_point = this.mergeClusterA.generator.getCenter();
                double[] v = this.mergeClusterA.generator.getDistanceVector(this.mergeClusterB.generator);
                for (int i = 0; i < v.length; ++i) {
                    merge_point[i] = merge_point[i] + v[i] * 0.5;
                }
                this.mergeClusterA.merging = true;
                this.mergeClusterB.merging = true;
                this.mergeClusterA.setDesitnation(merge_point);
                this.mergeClusterB.setDesitnation(merge_point);
                if (this.debug) {
                    System.out.println("Center1" + Arrays.toString(this.mergeClusterA.generator.getCenter()));
                    System.out.println("Center2" + Arrays.toString(this.mergeClusterB.generator.getCenter()));
                    System.out.println("Vector" + Arrays.toString(v));
                    System.out.println("Try to merge cluster " + this.mergeClusterA.generator.getId() + " into " + this.mergeClusterB.generator.getId() + " at " + Arrays.toString(merge_point) + " time " + this.numGeneratedInstances);
                }
                return "Init merge";
            }
        }
        if (this.mergeClusterA != null && this.mergeClusterB != null) {
            return this.mergeClusterA.tryMerging(this.mergeClusterB);
        }
        return "";
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    private double[] getNoisePoint() {
        double[] sample = new double[this.numAttsOption.getValue()];
        boolean incluster = true;
        int counter = 20;
        block0: while (incluster) {
            for (int j = 0; j < this.numAttsOption.getValue(); ++j) {
                sample[j] = this.instanceRandom.nextDouble();
            }
            incluster = false;
            if (this.noiseInClusterOption.isSet() || counter <= 0) continue;
            --counter;
            for (int c = 0; c < this.kernels.size(); ++c) {
                for (int m = 0; m < this.kernels.get((int)c).microClusters.size(); ++m) {
                    DenseInstance inst = new DenseInstance(1.0, sample);
                    if (!(this.kernels.get((int)c).microClusters.get(m).getInclusionProbability((Instance)inst) > 0.0)) continue;
                    incluster = true;
                    break;
                }
                if (incluster) continue block0;
            }
        }
        return sample;
    }

    private int chooseWeightedElement() {
        double r = this.instanceRandom.nextDouble();
        int i = 0;
        while (r > 0.0) {
            r -= this.kernels.get((int)i).generator.getWeight();
            ++i;
        }
        return --i;
    }

    private void normalizeWeights() {
        int i;
        double sumWeights = 0.0;
        for (i = 0; i < this.kernels.size(); ++i) {
            sumWeights += this.kernels.get((int)i).generator.getWeight();
        }
        for (i = 0; i < this.kernels.size(); ++i) {
            this.kernels.get((int)i).generator.setWeight(this.kernels.get((int)i).generator.getWeight() / sumWeights);
        }
    }

    public synchronized void addClusterChangeListener(ClusterEventListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public synchronized void removeClusterChangeListener(ClusterEventListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireClusterChange(long timestamp, String type, String message) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Vector targets;
            ClusterEvent event = new ClusterEvent(this, timestamp, type, message);
            RandomRBFGeneratorEvents randomRBFGeneratorEvents = this;
            synchronized (randomRBFGeneratorEvents) {
                targets = (Vector)this.listeners.clone();
            }
            Enumeration e = targets.elements();
            while (e.hasMoreElements()) {
                ClusterEventListener l = (ClusterEventListener)e.nextElement();
                l.changeCluster(event);
            }
        }
    }

    @Override
    public String getPurposeString() {
        return "Generates a random radial basis function stream.";
    }

    public String getParameterString() {
        return "";
    }

    private class GeneratorCluster {
        SphereCluster generator;
        int kill = -1;
        boolean merging = false;
        double[] moveVector;
        int totalMovementSteps;
        int currentMovementSteps;
        boolean isSplitting = false;
        LinkedList<DataPoint> points = new LinkedList();
        ArrayList<SphereCluster> microClusters = new ArrayList();
        ArrayList<ArrayList<DataPoint>> microClustersPoints = new ArrayList();
        ArrayList<Integer> microClustersDecay = new ArrayList();

        public GeneratorCluster(int label) {
            boolean outofbounds = true;
            int tryCounter = 0;
            while (outofbounds && tryCounter < RandomRBFGeneratorEvents.this.maxOverlapFitRuns) {
                ++tryCounter;
                outofbounds = false;
                double[] center = new double[RandomRBFGeneratorEvents.this.numAttsOption.getValue()];
                double radius = RandomRBFGeneratorEvents.this.kernelRadiiOption.getValue() + (double)(RandomRBFGeneratorEvents.this.instanceRandom.nextBoolean() ? -1 : 1) * RandomRBFGeneratorEvents.this.kernelRadiiRangeOption.getValue() * RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
                while (radius <= 0.0) {
                    radius = RandomRBFGeneratorEvents.this.kernelRadiiOption.getValue() + (double)(RandomRBFGeneratorEvents.this.instanceRandom.nextBoolean() ? -1 : 1) * RandomRBFGeneratorEvents.this.kernelRadiiRangeOption.getValue() * RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
                }
                for (int j = 0; j < RandomRBFGeneratorEvents.this.numAttsOption.getValue(); ++j) {
                    center[j] = RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
                    if (!(center[j] - radius < 0.0) && !(center[j] + radius > 1.0)) continue;
                    outofbounds = true;
                    break;
                }
                this.generator = new SphereCluster(center, radius);
            }
            if (tryCounter < RandomRBFGeneratorEvents.this.maxOverlapFitRuns) {
                this.generator.setId(label);
                double avgWeight = 1.0 / (double)RandomRBFGeneratorEvents.this.numClusterOption.getValue();
                double weight = avgWeight + (double)(RandomRBFGeneratorEvents.this.instanceRandom.nextBoolean() ? -1 : 1) * avgWeight * RandomRBFGeneratorEvents.this.densityRangeOption.getValue() * RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
                this.generator.setWeight(weight);
                this.setDesitnation(null);
            } else {
                this.generator = null;
                this.kill = 0;
                System.out.println("Tried " + RandomRBFGeneratorEvents.this.maxOverlapFitRuns + " times to create kernel. Reduce average radii.");
            }
        }

        public GeneratorCluster(int label, SphereCluster cluster) {
            this.generator = cluster;
            cluster.setId(label);
            this.setDesitnation(null);
        }

        public int getWorkID() {
            for (int c = 0; c < RandomRBFGeneratorEvents.this.kernels.size(); ++c) {
                if (!((GeneratorCluster)RandomRBFGeneratorEvents.this.kernels.get(c)).equals(this)) continue;
                return c;
            }
            return -1;
        }

        private void updateKernel() {
            if (this.kill == 0) {
                RandomRBFGeneratorEvents.this.kernels.remove(this);
            }
            if (this.kill > 0) {
                --this.kill;
            }
            for (int m = 0; m < this.microClusters.size(); ++m) {
                if (RandomRBFGeneratorEvents.this.numGeneratedInstances - this.microClustersDecay.get(m) <= RandomRBFGeneratorEvents.this.decayHorizonOption.getValue()) continue;
                this.microClusters.remove(m);
                this.microClustersPoints.remove(m);
                this.microClustersDecay.remove(m);
            }
            if (!this.points.isEmpty() && RandomRBFGeneratorEvents.this.numGeneratedInstances - this.points.getFirst().getTimestamp() >= RandomRBFGeneratorEvents.this.decayHorizonOption.getValue()) {
                this.points.removeFirst();
            }
        }

        private void addInstance(Instance instance) {
            boolean alt;
            DataPoint point = new DataPoint(instance, RandomRBFGeneratorEvents.this.numGeneratedInstances);
            this.points.add(point);
            int minMicroIndex = -1;
            double minHullDist = Double.MAX_VALUE;
            boolean inserted = false;
            for (int m = this.microClusters.size() - 1; m >= 0; --m) {
                SphereCluster micro = this.microClusters.get(m);
                double hulldist = micro.getCenterDistance((Instance)point) - micro.getRadius();
                if (hulldist <= 0.0) {
                    this.microClustersPoints.get(m).add(point);
                    this.microClustersDecay.set(m, RandomRBFGeneratorEvents.this.numGeneratedInstances);
                    inserted = true;
                    break;
                }
                if (!(hulldist < minHullDist)) continue;
                minMicroIndex = m;
                minHullDist = hulldist;
            }
            if (alt = true) {
                minMicroIndex = -1;
            }
            if (!inserted) {
                if (minMicroIndex != -1) {
                    this.microClustersPoints.get(minMicroIndex).add(point);
                    SphereCluster s = new SphereCluster((List<? extends Instance>)this.microClustersPoints.get(minMicroIndex), RandomRBFGeneratorEvents.this.numAttsOption.getValue());
                    if (s.getRadius() > this.generator.getRadius()) {
                        this.microClustersPoints.get(minMicroIndex).remove(this.microClustersPoints.get(minMicroIndex).size() - 1);
                        minMicroIndex = -1;
                    } else {
                        this.microClusters.set(minMicroIndex, s);
                        this.microClustersDecay.set(minMicroIndex, RandomRBFGeneratorEvents.this.numGeneratedInstances);
                    }
                }
                if (minMicroIndex == -1) {
                    int id;
                    ArrayList<DataPoint> microPoints = new ArrayList<DataPoint>();
                    microPoints.add(point);
                    SphereCluster s = !alt ? new SphereCluster(microPoints, RandomRBFGeneratorEvents.this.numAttsOption.getValue()) : new SphereCluster(this.generator.getCenter(), this.generator.getRadius(), 1.0);
                    this.microClusters.add(s);
                    this.microClustersPoints.add(microPoints);
                    this.microClustersDecay.add(RandomRBFGeneratorEvents.this.numGeneratedInstances);
                    for (id = 0; id < RandomRBFGeneratorEvents.this.kernels.size() && RandomRBFGeneratorEvents.this.kernels.get(id) != this; ++id) {
                    }
                    s.setGroundTruth(id);
                }
            }
        }

        private void move() {
            if (this.currentMovementSteps < this.totalMovementSteps) {
                ++this.currentMovementSteps;
                if (this.moveVector == null) {
                    return;
                }
                double[] center = this.generator.getCenter();
                boolean outofbounds = true;
                block0: while (outofbounds) {
                    double radius = this.generator.getRadius();
                    outofbounds = false;
                    center = this.generator.getCenter();
                    for (int d = 0; d < center.length; ++d) {
                        int n = d;
                        center[n] = center[n] + this.moveVector[d];
                        if (!(center[d] - radius < 0.0) && !(center[d] + radius > 1.0)) continue;
                        outofbounds = true;
                        this.setDesitnation(null);
                        continue block0;
                    }
                }
                this.generator.setCenter(center);
            } else if (!this.merging) {
                this.setDesitnation(null);
                this.isSplitting = false;
            }
        }

        void setDesitnation(double[] destination) {
            if (destination == null) {
                destination = new double[RandomRBFGeneratorEvents.this.numAttsOption.getValue()];
                for (int j = 0; j < RandomRBFGeneratorEvents.this.numAttsOption.getValue(); ++j) {
                    destination[j] = RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
                }
            }
            double[] center = this.generator.getCenter();
            int dim = center.length;
            double[] v = new double[dim];
            for (int d = 0; d < dim; ++d) {
                v[d] = destination[d] - center[d];
            }
            this.setMoveVector(v);
        }

        void setMoveVector(double[] vector) {
            int d;
            this.moveVector = vector;
            int speedInPoints = RandomRBFGeneratorEvents.this.speedOption.getValue();
            if (RandomRBFGeneratorEvents.this.speedRangeOption.getValue() > 0) {
                speedInPoints += (RandomRBFGeneratorEvents.this.instanceRandom.nextBoolean() ? -1 : 1) * RandomRBFGeneratorEvents.this.instanceRandom.nextInt(RandomRBFGeneratorEvents.this.speedRangeOption.getValue());
            }
            if (speedInPoints < 1) {
                speedInPoints = RandomRBFGeneratorEvents.this.speedOption.getValue();
            }
            double length = 0.0;
            for (d = 0; d < this.moveVector.length; ++d) {
                length += Math.pow(vector[d], 2.0);
            }
            length = Math.sqrt(length);
            this.totalMovementSteps = (int)(length / (RandomRBFGeneratorEvents.this.maxDistanceMoveThresholdByStep * (double)RandomRBFGeneratorEvents.this.kernelMovePointFrequency) * (double)speedInPoints);
            d = 0;
            while (d < this.moveVector.length) {
                int n = d++;
                this.moveVector[n] = this.moveVector[n] / (double)this.totalMovementSteps;
            }
            this.currentMovementSteps = 0;
        }

        private String tryMerging(GeneratorCluster merge) {
            String message = "";
            double overlapDegree = this.generator.overlapRadiusDegree(merge.generator);
            if (overlapDegree > RandomRBFGeneratorEvents.this.merge_threshold) {
                SphereCluster mcluster = merge.generator;
                double radius = Math.max(this.generator.getRadius(), mcluster.getRadius());
                this.generator.combine(mcluster);
                this.generator.setRadius(radius);
                message = "Clusters merging: " + ((RandomRBFGeneratorEvents)RandomRBFGeneratorEvents.this).mergeClusterB.generator.getId() + " into " + ((RandomRBFGeneratorEvents)RandomRBFGeneratorEvents.this).mergeClusterA.generator.getId();
                merge.kill = RandomRBFGeneratorEvents.this.decayHorizonOption.getValue();
                mcluster.setWeight(0.0);
                RandomRBFGeneratorEvents.this.normalizeWeights();
                RandomRBFGeneratorEvents.this.numActiveKernels--;
                RandomRBFGeneratorEvents.this.mergeClusterB = (RandomRBFGeneratorEvents.this.mergeClusterA = null);
                this.merging = false;
                RandomRBFGeneratorEvents.this.mergeKernelsOverlapping = false;
            } else if (overlapDegree > 0.0 && !RandomRBFGeneratorEvents.this.mergeKernelsOverlapping) {
                RandomRBFGeneratorEvents.this.mergeKernelsOverlapping = true;
                message = "Merge overlapping started";
            }
            return message;
        }

        private String splitKernel() {
            this.isSplitting = true;
            double radius = RandomRBFGeneratorEvents.this.kernelRadiiOption.getValue();
            double avgWeight = 1.0 / (double)RandomRBFGeneratorEvents.this.numClusterOption.getValue();
            double weight = avgWeight + avgWeight * RandomRBFGeneratorEvents.this.densityRangeOption.getValue() * RandomRBFGeneratorEvents.this.instanceRandom.nextDouble();
            SphereCluster spcluster = null;
            double[] center = this.generator.getCenter();
            spcluster = new SphereCluster(center, radius, weight);
            if (spcluster != null) {
                GeneratorCluster gc = new GeneratorCluster(RandomRBFGeneratorEvents.this.clusterIdCounter++, spcluster);
                gc.isSplitting = true;
                RandomRBFGeneratorEvents.this.kernels.add(gc);
                RandomRBFGeneratorEvents.this.normalizeWeights();
                RandomRBFGeneratorEvents.this.numActiveKernels++;
                return "Split from Kernel " + this.generator.getId();
            }
            System.out.println("Tried to split new kernel from C" + this.generator.getId() + ". Not enough room for new cluster, decrease average radii, number of clusters or enable overlap.");
            return "";
        }

        private String fadeOut() {
            this.kill = RandomRBFGeneratorEvents.this.decayHorizonOption.getValue();
            this.generator.setWeight(0.0);
            RandomRBFGeneratorEvents.this.numActiveKernels--;
            RandomRBFGeneratorEvents.this.normalizeWeights();
            return "Fading out C" + this.generator.getId();
        }
    }
}

