/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    protected static TimeZone m_TimeZone = TimeZone.getDefault();
    protected static Locale m_Locale = Locale.getDefault();

    public static synchronized void setTimeZone(TimeZone value) {
        m_TimeZone = value;
    }

    public static synchronized TimeZone getTimeZone() {
        return m_TimeZone;
    }

    public static synchronized void setLocale(Locale value) {
        m_Locale = value;
    }

    public static synchronized Locale getLocale() {
        return m_Locale;
    }

    public static synchronized Calendar getCalendar() {
        return new GregorianCalendar(DateUtils.getTimeZone(), DateUtils.getLocale());
    }

    public static DateFormat getTimestampFormatter() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getTimestampFormatterMsecs() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    public static boolean isValid(String pattern) {
        try {
            new SimpleDateFormat(pattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date earlier(Date date, int type, int decrement) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, -Math.abs(decrement));
        return cal.getTime();
    }

    public static Date later(Date date, int type, int increment) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, Math.abs(increment));
        return cal.getTime();
    }

    public static Date set(Date date, int type, int value) {
        Date result;
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        try {
            cal.set(type, value);
            result = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static boolean isBefore(Date base, Date check) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(check);
        return cal.before(base);
    }

    public static boolean isAfter(Date base, Date check) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(base);
        return cal.before(check);
    }
}

