/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.InsertDelta;
import difflib.Patch;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DiffUtils {
    public static final char INDICATOR_CHANGED = 'c';
    public static final char INDICATOR_ADDED = 'a';
    public static final char INDICATOR_DELETED = 'd';
    public static final char INDICATOR_SAME = ' ';
    public static final String SOURCE = "<";
    public static final String DESTINATION = ">";
    public static final String SEPARATOR_UNIFIED = "---";
    public static final String SEPARATOR_SIDEBYSIDE = " | ";
    public static final String OPTION_UNIFIED = "unified";
    public static final String OPTION_SIDEBYSIDE = "side-by-side";
    public static final String OPTION_BRIEF = "brief";
    public static final int SIDEBYSIDE_SIZE = 5;
    public static final int SIDEBYSIDE_FIRST = 0;
    public static final int SIDEBYSIDE_SECOND = 1;
    public static final int SIDEBYSIDE_INDICATOR = 2;
    public static final int SIDEBYSIDE_STARTPOS = 3;
    public static final int SIDEBYSIDE_ENDPOS = 4;

    protected static Vector<String> loadFromFile(File file) {
        if (file.isDirectory()) {
            return new Vector<String>();
        }
        return FileUtils.loadFromFile(file);
    }

    public static boolean isDifferent(File file1, File file2) {
        return DiffUtils.isDifferent(DiffUtils.loadFromFile(file1), DiffUtils.loadFromFile(file2));
    }

    public static boolean isDifferent(String[] list1, String[] list2) {
        return DiffUtils.isDifferent(Arrays.asList(list1), Arrays.asList(list2));
    }

    public static boolean isDifferent(List<String> list1, List<String> list2) {
        Patch patch = difflib.DiffUtils.diff(list1, list2);
        boolean result = patch.getDeltas().size() > 0;
        return result;
    }

    protected static String toString(String ind, List lines) {
        StringBuilder result = new StringBuilder();
        for (Object line : lines) {
            result.append(ind + " " + line + "\n");
        }
        return result.toString();
    }

    public static String unified(File file1, File file2) {
        return DiffUtils.unified(DiffUtils.loadFromFile(file1), DiffUtils.loadFromFile(file2));
    }

    protected static String createRange(Chunk chunk) {
        if (chunk.size() == 1) {
            return chunk.getPosition() + 1 + "";
        }
        return chunk.getPosition() + 1 + "," + (chunk.getPosition() + chunk.size());
    }

    public static String unified(List<String> list1, List<String> list2) {
        Patch patch = difflib.DiffUtils.diff(list1, list2);
        StringBuilder result = new StringBuilder();
        for (Delta delta : patch.getDeltas()) {
            if (delta instanceof InsertDelta) {
                result.append(delta.getOriginal().getPosition() + "a" + DiffUtils.createRange(delta.getRevised()) + "\n");
                result.append(DiffUtils.toString(DESTINATION, delta.getRevised().getLines()));
                continue;
            }
            if (delta instanceof DeleteDelta) {
                result.append(DiffUtils.createRange(delta.getOriginal()) + "d" + delta.getRevised().getPosition() + "\n");
                result.append(DiffUtils.toString(SOURCE, delta.getOriginal().getLines()));
                continue;
            }
            result.append(DiffUtils.createRange(delta.getOriginal()) + "c");
            result.append(DiffUtils.createRange(delta.getRevised()) + "\n");
            result.append(DiffUtils.toString(SOURCE, delta.getOriginal().getLines()));
            result.append("---\n");
            result.append(DiffUtils.toString(DESTINATION, delta.getRevised().getLines()));
        }
        return result.toString();
    }

    public static SideBySideDiff sideBySide(File file1, File file2) {
        return DiffUtils.sideBySide(DiffUtils.loadFromFile(file1), DiffUtils.loadFromFile(file2));
    }

    public static SideBySideDiff sideBySide(String[] list1, String[] list2) {
        return DiffUtils.sideBySide(Arrays.asList(list1), Arrays.asList(list2));
    }

    protected static void addToList(int from, int to, List<String> source, List dest) {
        for (int i = from; i <= to; ++i) {
            dest.add(source.get(i));
        }
    }

    protected static void addToList(int from, int to, Object obj, List dest) {
        for (int i = from; i <= to; ++i) {
            dest.add(obj);
        }
    }

    public static SideBySideDiff sideBySide(List<String> list1, List<String> list2) {
        List[] result = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        Patch patch = difflib.DiffUtils.diff(list1, list2);
        if (patch.getDeltas().size() == 0) {
            result[0].addAll(list1);
            result[1].addAll(list2);
            DiffUtils.addToList(0, list1.size() - 1, Character.valueOf(' '), result[2]);
            return new SideBySideDiff(result);
        }
        int to = 0;
        for (Delta delta : patch.getDeltas()) {
            int from = to;
            to = delta.getOriginal().getPosition() - 1;
            DiffUtils.addToList(from, to, list1, result[0]);
            DiffUtils.addToList(from, to, list1, result[1]);
            DiffUtils.addToList(from, to, Character.valueOf(' '), result[2]);
            result[3].add(result[0].size());
            if (delta instanceof InsertDelta) {
                DiffUtils.addToList(0, delta.getRevised().size() - 1, new Filler(), result[0]);
                result[1].addAll(delta.getRevised().getLines());
                DiffUtils.addToList(0, delta.getRevised().size() - 1, Character.valueOf('a'), result[2]);
                to = delta.getOriginal().getPosition() + delta.getOriginal().size();
            } else if (delta instanceof DeleteDelta) {
                result[0].addAll(delta.getOriginal().getLines());
                DiffUtils.addToList(0, delta.getOriginal().size() - 1, new Filler(), result[1]);
                DiffUtils.addToList(0, delta.getOriginal().size() - 1, Character.valueOf('d'), result[2]);
                to = delta.getOriginal().getPosition() + delta.getOriginal().size();
            } else {
                result[0].addAll(delta.getOriginal().getLines());
                result[1].addAll(delta.getRevised().getLines());
                DiffUtils.addToList(1, Math.max(delta.getOriginal().size(), delta.getRevised().size()), Character.valueOf('c'), result[2]);
                int sizeDiff = delta.getRevised().size() - delta.getOriginal().size();
                if (sizeDiff > 0) {
                    DiffUtils.addToList(1, sizeDiff, new Filler(), result[0]);
                }
                if (sizeDiff < 0) {
                    DiffUtils.addToList(1, -sizeDiff, new Filler(), result[1]);
                }
                to = delta.getOriginal().getPosition() + delta.getOriginal().size();
            }
            result[4].add(result[0].size());
        }
        if (to < list1.size()) {
            DiffUtils.addToList(to, list1.size() - 1, list1, result[0]);
            DiffUtils.addToList(to, list1.size() - 1, list1, result[1]);
            DiffUtils.addToList(to, list1.size() - 1, Character.valueOf(' '), result[2]);
        }
        return new SideBySideDiff(result);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        if (args.length != 3) {
            System.err.println("\nUsage: " + DiffUtils.class.getName() + " <" + OPTION_UNIFIED + "|" + OPTION_SIDEBYSIDE + "|" + OPTION_BRIEF + "> <file1> <file2>\n");
            return;
        }
        PlaceholderFile file1 = new PlaceholderFile(args[1]);
        if (file1.isDirectory()) {
            System.err.println("File '" + file1 + "' is a directory!");
            return;
        }
        if (!file1.exists()) {
            System.err.println("File '" + file1 + "' does not exist!");
            return;
        }
        PlaceholderFile file2 = new PlaceholderFile(args[2]);
        if (file2.isDirectory()) {
            System.err.println("File '" + file2 + "' is a directory!");
            return;
        }
        if (!file2.exists()) {
            System.err.println("File '" + file2 + "' does not exist!");
            return;
        }
        if (args[0].equals(OPTION_UNIFIED)) {
            System.out.println(DiffUtils.unified(file1, file2));
            return;
        }
        if (args[0].equals(OPTION_SIDEBYSIDE)) {
            System.out.println(DiffUtils.sideBySide(file1, file2));
            return;
        }
        if (args[0].equals(OPTION_BRIEF)) {
            if (!DiffUtils.isDifferent(file1, file2)) return;
            System.out.println("Files " + file1 + " and " + file2 + " differ");
            return;
        }
        System.err.println("Only 'unified', 'side-by-side' and 'brief' are available as options!");
    }

    public static class Filler
    implements Serializable {
        private static final long serialVersionUID = 3295616348711569065L;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj instanceof Filler;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "";
        }
    }

    public static class SideBySideDiff
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -6775907286936991130L;
        protected List[] m_Diff;

        public SideBySideDiff() {
            this(new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()});
        }

        public SideBySideDiff(List[] diff) {
            if (diff.length != 5) {
                throw new IllegalArgumentException("Expected array with length 5 but got: " + diff.length);
            }
            this.m_Diff = (List[])diff.clone();
        }

        public List getLeft() {
            return this.m_Diff[0];
        }

        public List getRight() {
            return this.m_Diff[1];
        }

        public List getIndicator() {
            return this.m_Diff[2];
        }

        public List getStartPos() {
            return this.m_Diff[3];
        }

        public boolean hasDifferences() {
            return this.m_Diff[3].size() > 0;
        }

        public int differences() {
            return this.m_Diff[3].size();
        }

        public int lineToDelta(int line) {
            int result = -1;
            if (!this.hasDifferences()) {
                return result;
            }
            List start = this.m_Diff[3];
            List end = this.m_Diff[4];
            for (int i = 0; i < start.size(); ++i) {
                if ((Integer)start.get(i) < line || line > (Integer)end.get(i)) continue;
                result = i;
                break;
            }
            return result;
        }

        public int deltaToLine(int delta, boolean start) {
            int result = -1;
            if (delta >= 0 && delta < this.m_Diff[3].size()) {
                result = start ? ((Integer)this.m_Diff[3].get(delta)).intValue() : ((Integer)this.m_Diff[4].get(delta)).intValue();
            }
            return result;
        }

        public boolean hasNextDelta(int line) {
            return this.getNextDelta(line) != -1;
        }

        public int getNextDelta(int line) {
            int result = -1;
            int delta = this.lineToDelta(line);
            if (delta == -1) {
                return result;
            }
            if (++delta < this.m_Diff[3].size()) {
                result = delta;
            }
            return result;
        }

        public boolean hasPreviousDelta(int line) {
            return this.getPreviousDelta(line) != -1;
        }

        public int getPreviousDelta(int line) {
            int result = -1;
            int delta = this.lineToDelta(line);
            if (delta == -1) {
                return result;
            }
            if (--delta >= 0) {
                result = delta;
            }
            return result;
        }

        public SideBySideDiff clone() {
            return new SideBySideDiff(this.m_Diff);
        }

        public String toString(String separator) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.m_Diff[0].size(); ++i) {
                result.append(this.m_Diff[2].get(i));
                result.append(separator);
                result.append(this.m_Diff[0].get(i));
                result.append(separator);
                result.append(this.m_Diff[1].get(i));
                result.append("\n");
            }
            return result.toString();
        }

        public String toString() {
            return this.toString(DiffUtils.SEPARATOR_SIDEBYSIDE);
        }
    }
}

