/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CustomDisplayStringProvider;
import adams.core.ExampleProvider;
import java.io.Serializable;
import java.util.Vector;

public class Range
implements Serializable,
CustomDisplayStringProvider,
Comparable<Range>,
ExampleProvider {
    private static final long serialVersionUID = -7995710565507092711L;
    public static final String RANGE = "-";
    public static final String SEPARATOR = ",";
    public static final String FIRST = "first";
    public static final String SECOND = "second";
    public static final String THIRD = "third";
    public static final String LAST_1 = "last_1";
    public static final String LAST_2 = "last_2";
    public static final String LAST = "last";
    public static final String INV_START = "inv(";
    public static final String INV_END = ")";
    public static final String ALL = "first-last";
    protected String m_Range;
    protected String m_ActualRange;
    protected int m_Max;
    protected boolean m_Inverted;
    protected Vector<SubRange> m_SubRanges;

    public Range() {
        this("");
    }

    public Range(String range) {
        this(range, -1);
    }

    public Range(String range, int max) {
        this.setRange(range);
        this.setMax(max);
    }

    public void setRange(String value) {
        this.m_SubRanges = null;
        this.m_Range = this.clean(value);
        this.m_Inverted = this.m_Range.startsWith(INV_START) && this.m_Range.endsWith(INV_END);
        this.m_ActualRange = this.m_Inverted ? this.m_Range.substring(INV_START.length(), this.m_Range.length() - INV_END.length()) : this.m_Range;
    }

    public void setIndices(Integer[] indices) {
        int[] intIndices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            intIndices[i] = indices[i];
        }
        this.setIndices(intIndices);
    }

    public void setIndices(int[] indices) {
        StringBuilder range = new StringBuilder();
        int start = -1;
        int end = -1;
        if (indices.length > 0) {
            start = indices[0];
        }
        for (int i = 1; i < indices.length; ++i) {
            int diff = indices[i] - indices[i - 1];
            if (diff > 1) {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                if (start != indices[i - 1]) {
                    range.append(start + 1 + RANGE + (indices[i - 1] + 1));
                } else {
                    range.append(start + 1);
                }
                start = indices[i];
                end = -1;
                continue;
            }
            end = indices[i];
        }
        if (start != -1) {
            if (end != -1) {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                if (start != end) {
                    range.append(start + 1 + RANGE + (end + 1));
                } else {
                    range.append(start + 1);
                }
            } else {
                if (range.length() > 0) {
                    range.append(SEPARATOR);
                }
                range.append(start + 1);
            }
        }
        this.setRange(range.toString());
    }

    public boolean isInverted() {
        return this.m_Inverted;
    }

    public void setInverted(boolean value) {
        if (value) {
            this.setRange(INV_START + this.m_ActualRange + INV_END);
        } else {
            this.setRange(this.m_ActualRange);
        }
    }

    public String getRange() {
        return this.m_Range;
    }

    public void setMax(int value) {
        if (value != this.m_Max) {
            this.m_Max = value <= 0 ? -1 : value;
            this.m_SubRanges = null;
        }
    }

    public int getMax() {
        return this.m_Max;
    }

    public boolean hasRange() {
        return this.m_Range.length() > 0;
    }

    protected String clean(String s) {
        int i;
        StringBuilder result = new StringBuilder();
        String tmp = s.toLowerCase();
        tmp = tmp.replace(FIRST, "A").replace(LAST, "Z");
        tmp = tmp.replace(SECOND, "B").replace(LAST_1, "Y");
        tmp = tmp.replace(THIRD, "C").replace(LAST_2, "X");
        tmp = tmp.replace(INV_START, "P").replace(INV_END, "Q");
        StringBuilder tmp2 = new StringBuilder();
        for (i = 0; i < tmp.length(); ++i) {
            char chr = tmp.charAt(i);
            if (chr == 'A') {
                tmp2.append(FIRST);
                continue;
            }
            if (chr == 'B') {
                tmp2.append(SECOND);
                continue;
            }
            if (chr == 'C') {
                tmp2.append(THIRD);
                continue;
            }
            if (chr == 'X') {
                tmp2.append(LAST_2);
                continue;
            }
            if (chr == 'Y') {
                tmp2.append(LAST_1);
                continue;
            }
            if (chr == 'Z') {
                tmp2.append(LAST);
                continue;
            }
            if (chr == 'P') {
                tmp2.append(INV_START);
                continue;
            }
            if (chr == 'Q') {
                tmp2.append(INV_END);
                continue;
            }
            if (chr == SEPARATOR.charAt(0) || chr == RANGE.charAt(0) || chr == '_') {
                tmp2.append(chr);
                continue;
            }
            if (chr < '0' || chr > '9') continue;
            tmp2.append(chr);
        }
        boolean inverted = false;
        if (tmp2.length() >= INV_START.length() + 1 + INV_END.length()) {
            boolean bl = inverted = tmp2.toString().startsWith(INV_START) && tmp2.toString().endsWith(INV_END);
            if (inverted) {
                tmp2 = new StringBuilder(tmp2.substring(INV_START.length(), tmp2.length() - INV_END.length()));
            }
        }
        String[] ranges = tmp2.toString().split(SEPARATOR);
        for (i = 0; i < ranges.length; ++i) {
            if (ranges[i].indexOf(RANGE) == -1) {
                try {
                    this.parse(ranges[i]);
                    if (result.length() > 0) {
                        result.append(SEPARATOR);
                    }
                    result.append(ranges[i]);
                }
                catch (Exception e) {}
                continue;
            }
            String[] parts = ranges[i].split(RANGE);
            if (parts.length != 2) continue;
            try {
                int from = this.parse(parts[0], Integer.MAX_VALUE);
                int to = this.parse(parts[1], Integer.MAX_VALUE);
                if (from > to) continue;
                if (result.length() > 0) {
                    result.append(SEPARATOR);
                }
                result.append(ranges[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inverted) {
            result.insert(0, INV_START);
            result.append(INV_END);
        }
        return result.toString();
    }

    protected int parse(String s, int max) {
        int result = s.equals(FIRST) ? 0 : (s.equals(SECOND) ? 1 : (s.equals(THIRD) ? 2 : (s.equals(LAST_2) ? max - 3 : (s.equals(LAST_1) ? max - 2 : (s.equals(LAST) ? max - 1 : Integer.parseInt(s) - 1)))));
        return result;
    }

    protected int parse(String s) {
        return this.parse(s, this.m_Max);
    }

    protected Vector<SubRange> parse(StringBuilder errors) {
        if (errors.length() > 0) {
            errors.delete(0, errors.length());
        }
        Vector<SubRange> result = new Vector<SubRange>();
        if (this.m_Max == -1) {
            return result;
        }
        String[] ranges = this.m_ActualRange.split(SEPARATOR);
        for (int i = 0; i < ranges.length; ++i) {
            int to;
            int from;
            if (ranges[i].length() == 0) continue;
            if (ranges[i].indexOf(RANGE) == -1) {
                from = this.parse(ranges[i]);
                if (from >= 0 && from < this.m_Max) {
                    result.add(new SubRange(from));
                    continue;
                }
                errors.append(ranges[i] + "\n");
                continue;
            }
            String[] parts = ranges[i].split(RANGE);
            from = this.parse(parts[0]);
            if (from <= (to = this.parse(parts[1])) && from >= 0 && to < this.m_Max) {
                result.add(new SubRange(from, to));
                continue;
            }
            if (from <= to && from >= 0 && from < this.m_Max) {
                result.add(new SubRange(from, this.m_Max));
                continue;
            }
            errors.append(ranges[i] + "\n");
        }
        return result;
    }

    protected synchronized Vector<SubRange> getSubRanges() {
        if (this.m_SubRanges == null) {
            this.m_SubRanges = this.parse(new StringBuilder());
        }
        return this.m_SubRanges;
    }

    public boolean isInRange(int index) {
        boolean result = this.m_Inverted;
        Vector<SubRange> ranges = this.getSubRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            if (this.m_Inverted) {
                if (!ranges.get(i).isInRange(index)) continue;
                result = false;
                break;
            }
            if (!ranges.get(i).isInRange(index)) continue;
            result = true;
            break;
        }
        return result;
    }

    public int[] getIntIndices() {
        int i;
        Vector<Integer> indices = new Vector<Integer>();
        for (i = 0; i < this.m_Max; ++i) {
            if (!this.isInRange(i)) continue;
            indices.add(i);
        }
        int[] result = new int[indices.size()];
        for (i = 0; i < indices.size(); ++i) {
            result[i] = (Integer)indices.get(i);
        }
        return result;
    }

    public int[][] getIntSegments() {
        if (this.getSubRanges() == null) {
            return new int[0][];
        }
        int[][] result = new int[this.getSubRanges().size()][2];
        for (int i = 0; i < this.getSubRanges().size(); ++i) {
            SubRange sub = this.getSubRanges().get(i);
            result[i][0] = sub.getFrom();
            result[i][1] = sub.hasTo() ? sub.getTo().intValue() : sub.getFrom().intValue();
        }
        return result;
    }

    @Override
    public int compareTo(Range o) {
        int[] indicesOther;
        int[] indicesThis = this.getIntIndices();
        int result = new Integer(indicesThis.length).compareTo(new Integer((indicesOther = o.getIntIndices()).length));
        if (result == 0) {
            for (int i = 0; i < indicesThis.length && (result = new Integer(indicesThis[i]).compareTo(new Integer(indicesOther[i]))) == 0; ++i) {
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        return this.compareTo((Range)obj) == 0;
    }

    public int hashCode() {
        return this.m_Range.hashCode();
    }

    public String toString() {
        return "range=" + this.m_Range + ", max=" + this.m_Max + ", inv=" + this.m_Inverted;
    }

    @Override
    public String toDisplay() {
        return this.getRange();
    }

    public String toExplicitRange() {
        StringBuilder result = new StringBuilder();
        int[] indices = this.getIntIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                result.append(SEPARATOR);
            }
            result.append("" + (indices[i] + 1));
        }
        return result.toString();
    }

    @Override
    public String getExample() {
        return "A range is a comma-separated list of single 1-based indices or sub-ranges of indices ('start-end'); 'inv(...)' inverts the range '...'; the following placeholders can be used as well: first, second, third, last_2, last_1, last";
    }

    public static Range toRange(int[] indices) {
        if (indices.length == 0) {
            return new Range();
        }
        StringBuilder range = new StringBuilder();
        int i = 1;
        Integer start = indices[0];
        Integer current = indices[0];
        range.append(current + 1);
        while (i < indices.length) {
            if (indices[i] - current > 1) {
                if (start < current) {
                    range.append(RANGE);
                    range.append(current + 1);
                }
                range.append(SEPARATOR);
                start = indices[i];
                current = indices[i];
                range.append(current + 1);
            } else {
                current = indices[i];
            }
            if (++i != indices.length || start >= current) continue;
            range.append(RANGE);
            range.append(current + 1);
        }
        Range result = new Range(range.toString());
        return result;
    }

    public static boolean isValid(String s, int max) {
        Range range = new Range(s);
        boolean result = s.equals(range.getRange()) && range.getRange().length() > 0;
        return result;
    }

    public static class SubRange
    implements Serializable,
    Comparable<SubRange> {
        private static final long serialVersionUID = -1352323320597824993L;
        protected Integer m_From;
        protected Integer m_To;

        public SubRange(int from) {
            this(from, null);
        }

        public SubRange(int from, Integer to) {
            this.m_From = from;
            this.m_To = to;
        }

        public Integer getFrom() {
            return this.m_From;
        }

        public boolean hasTo() {
            return this.m_To != null;
        }

        public Integer getTo() {
            return this.m_To;
        }

        public boolean isInRange(int index) {
            if (this.m_To == null) {
                return this.m_From == index;
            }
            return this.m_From <= index && index <= this.m_To;
        }

        @Override
        public int compareTo(SubRange o) {
            int result = this.getFrom().compareTo(o.getFrom());
            if (result == 0) {
                result = this.hasTo() && o.hasTo() ? this.getTo().compareTo(o.getTo()) : (!this.hasTo() ? -1 : 1);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SubRange)) {
                return false;
            }
            return this.compareTo((SubRange)obj) == 0;
        }

        public String toString() {
            if (this.m_To == null) {
                return "num=" + this.m_From;
            }
            return "from=" + this.m_From + ", to=" + this.m_To;
        }
    }
}

