/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import org.pegdown.PegDownProcessor;

public class MarkDown
extends AbstractBaseString {
    private static final long serialVersionUID = 7100089984419357692L;
    protected transient PegDownProcessor m_Processor;
    protected String m_HTML;

    public MarkDown() {
        this("");
    }

    public MarkDown(String s) {
        super(s);
    }

    protected synchronized PegDownProcessor getProcessor() {
        if (this.m_Processor == null) {
            this.m_Processor = new PegDownProcessor();
        }
        return this.m_Processor;
    }

    @Override
    protected String convert(String value) {
        String result = super.convert(value);
        this.m_HTML = null;
        return result;
    }

    @Override
    public boolean isValid(String value) {
        try {
            this.getProcessor().markdownToHtml(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String htmlValue() {
        if (this.m_HTML == null) {
            this.m_HTML = this.getProcessor().markdownToHtml(this.getValue());
        }
        return this.m_HTML;
    }

    @Override
    public String getTipText() {
        return "An MarkDown string.";
    }
}

