/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.PlaceholderDirectory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;

public class ProcessUtils {
    public static final long AUTO_PID = -999L;
    public static final long NO_PID = -1L;

    public static long getVirtualMachinePID() {
        long result;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            result = Long.parseLong(name.replaceAll("@.*", ""));
        }
        catch (Exception e) {
            result = -1L;
        }
        return result;
    }

    protected static Object execute(Process process, boolean stderr) throws Exception {
        String line;
        StringBuilder output = new StringBuilder();
        BufferedReader reader = stderr ? new BufferedReader(new InputStreamReader(process.getErrorStream()), 1024) : new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
        while ((line = reader.readLine()) != null) {
            output.append(line);
            output.append("\n");
        }
        int exitVal = process.waitFor();
        Object result = exitVal != 0 ? new Integer(exitVal) : output.toString();
        return result;
    }

    public static Object execute(String cmd, boolean stderr) throws Exception {
        return ProcessUtils.execute(cmd, null, stderr);
    }

    public static Object execute(String cmd, PlaceholderDirectory cwd, boolean stderr) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd, null, cwd == null ? null : cwd.getAbsoluteFile());
        return ProcessUtils.execute(process, stderr);
    }

    public static Object execute(String[] cmd, boolean stderr) throws Exception {
        return ProcessUtils.execute(cmd, null, stderr);
    }

    public static Object execute(String[] cmd, PlaceholderDirectory cwd, boolean stderr) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd, null, cwd == null ? null : cwd.getAbsoluteFile());
        return ProcessUtils.execute(process, stderr);
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

