/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.License;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BasePassword;
import adams.env.Environment;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;

@MixedCopyright(copyright="2010 Real Gagnon", author="Real Gagnon", license=License.CC_BY_NC_SA_25, url="http://www.rgagnon.com/javadetails/java-0085.html")
public class ProxyHelper {
    public static final String FILENAME = "Proxy.props";
    public static final String PROXY_TYPE = "ProxyType";
    public static final String HTTP_HOST = "HttpHost";
    public static final String HTTP_PORT = "HttpPort";
    public static final String HTTP_AUTHENTICATION = "HttpAuthentication";
    public static final String HTTP_USER = "HttpUser";
    public static final String HTTP_PASSWORD = "HttpPassword";
    public static final String HTTP_NOPROXY = "HttpNoProxy";
    public static final String SOCKS_HOST = "SocksHost";
    public static final String SOCKS_PORT = "SocksPort";
    public static final String SOCKS_AUTHENTICATION = "SocksAuthentication";
    public static final String SOCKS_USER = "SocksUser";
    public static final String SOCKS_PASSWORD = "SocksPassword";
    protected static ProxyHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;

    private ProxyHelper() {
        this.reload();
    }

    public void initializeProxy() {
        final Proxy.Type type = this.getProxyType();
        if (this.getAuthentication(type)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ProxyHelper.this.getUser(type), ProxyHelper.this.getPassword(type).getValue().toCharArray());
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
        switch (type) {
            case HTTP: {
                System.setProperty("http.proxyHost", this.getHost(type));
                System.setProperty("http.proxyPort", Integer.toString(this.getPort(type)));
                System.setProperty("ftp.proxyHost", this.getHost(type));
                System.setProperty("ftp.proxyPort", Integer.toString(this.getPort(type)));
                break;
            }
            case SOCKS: {
                System.setProperty("socksProxyHost", this.getHost(type));
                System.setProperty("socksProxyPort", Integer.toString(this.getPort(type)));
            }
        }
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public Proxy.Type getProxyType() {
        Proxy.Type result;
        try {
            result = Proxy.Type.valueOf(this.m_Properties.getProperty(PROXY_TYPE, "DIRECT"));
        }
        catch (Exception e) {
            System.err.println("Failed to parse proxy type:");
            e.printStackTrace();
            result = Proxy.Type.DIRECT;
        }
        return result;
    }

    public void setProxyType(Proxy.Type value) {
        this.m_Modified = true;
        this.m_Properties.setString(PROXY_TYPE, value.toString());
    }

    public String getHost(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getProperty(HTTP_HOST, "http.proxy.com");
            }
            case SOCKS: {
                return this.m_Properties.getProperty(SOCKS_HOST, "socks.proxy.com");
            }
        }
        return "";
    }

    public void setHost(Proxy.Type type, String value) {
        this.m_Modified = true;
        switch (type) {
            case HTTP: {
                this.m_Properties.setProperty(HTTP_HOST, value);
                break;
            }
            case SOCKS: {
                this.m_Properties.setProperty(SOCKS_HOST, value);
            }
        }
    }

    public int getPort(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getInteger(HTTP_PORT, 80);
            }
            case SOCKS: {
                return this.m_Properties.getInteger(SOCKS_PORT, 1080);
            }
        }
        return -1;
    }

    public void setPort(Proxy.Type type, int value) {
        switch (type) {
            case HTTP: {
                this.m_Modified = true;
                this.m_Properties.setInteger(HTTP_PORT, value);
                break;
            }
            case SOCKS: {
                this.m_Modified = true;
                this.m_Properties.setInteger(SOCKS_PORT, value);
            }
        }
    }

    public boolean getAuthentication(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getBoolean(HTTP_AUTHENTICATION, false);
            }
            case SOCKS: {
                return this.m_Properties.getBoolean(SOCKS_AUTHENTICATION, false);
            }
        }
        return false;
    }

    public void setAuthentication(Proxy.Type type, boolean value) {
        switch (type) {
            case HTTP: {
                this.m_Modified = true;
                this.m_Properties.setBoolean(HTTP_AUTHENTICATION, value);
                break;
            }
            case SOCKS: {
                this.m_Modified = true;
                this.m_Properties.setBoolean(SOCKS_AUTHENTICATION, value);
            }
        }
    }

    public String getUser(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getProperty(HTTP_USER, "");
            }
            case SOCKS: {
                return this.m_Properties.getProperty(SOCKS_USER, "");
            }
        }
        return "";
    }

    public void setUser(Proxy.Type type, String value) {
        switch (type) {
            case HTTP: {
                this.m_Modified = true;
                this.m_Properties.setString(HTTP_USER, value);
                break;
            }
            case SOCKS: {
                this.m_Modified = true;
                this.m_Properties.setString(SOCKS_USER, value);
            }
        }
    }

    public BasePassword getPassword(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getPassword(HTTP_PASSWORD, new BasePassword());
            }
            case SOCKS: {
                return this.m_Properties.getPassword(SOCKS_PASSWORD, new BasePassword());
            }
        }
        return new BasePassword();
    }

    public void setPassword(Proxy.Type type, BasePassword value) {
        switch (type) {
            case HTTP: {
                this.m_Modified = true;
                this.m_Properties.setPassword(HTTP_PASSWORD, value);
                break;
            }
            case SOCKS: {
                this.m_Modified = true;
                this.m_Properties.setPassword(SOCKS_PASSWORD, value);
            }
        }
    }

    public String[] getNoProxy(Proxy.Type type) {
        switch (type) {
            case HTTP: {
                return this.m_Properties.getProperty(HTTP_NOPROXY, "localhost|127.0.0.1").split("\\|");
            }
        }
        return new String[0];
    }

    public void setNoProxy(Proxy.Type type, String[] value) {
        switch (type) {
            case HTTP: {
                this.m_Modified = true;
                this.m_Properties.setString(HTTP_NOPROXY, Utils.flatten(value, "|"));
            }
        }
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("proxy");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("proxy", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public static synchronized ProxyHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ProxyHelper();
        }
        return m_Singleton;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        for (Proxy.Type type : Proxy.Type.values()) {
            System.out.println("--> " + (Object)((Object)type));
            System.out.println("  Host: " + ProxyHelper.getSingleton().getHost(type) + ":" + ProxyHelper.getSingleton().getPort(type));
            System.out.println("  No Proxy: " + Utils.arrayToString(ProxyHelper.getSingleton().getNoProxy(type)));
            System.out.println("  Use authentication: " + ProxyHelper.getSingleton().getAuthentication(type));
            if (!ProxyHelper.getSingleton().getAuthentication(type)) continue;
            System.out.println("  Authentication: " + ProxyHelper.getSingleton().getUser(type) + "/" + ProxyHelper.getSingleton().getPassword(type).getValue().replaceAll(".", "*"));
        }
    }
}

