/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import JSci.maths.wavelet.IllegalScalingException;
import adams.core.CleanUpHandler;
import adams.core.ConsoleObject;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public abstract class AbstractOptionConsumer<C, V>
extends ConsoleObject
implements CleanUpHandler {
    private static final long serialVersionUID = -6229518298821665902L;
    protected int m_DebugLevel;
    protected C m_Input;
    protected boolean m_UsePropertyNames;
    protected OptionHandler m_Output;
    protected Vector<String> m_Errors;
    protected Vector<String> m_Warnings;
    protected HashSet<String> m_SkippedProperties;

    public AbstractOptionConsumer() {
        this.initialize();
    }

    public abstract String globalInfo();

    protected void initialize() {
        this.m_DebugLevel = 0;
        this.m_Input = null;
        this.m_UsePropertyNames = false;
        this.m_Errors = new Vector();
        this.m_Warnings = new Vector();
        this.m_SkippedProperties = new HashSet();
    }

    protected void reset() {
        this.m_Output = null;
        this.m_Errors.clear();
        this.m_Warnings.clear();
    }

    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
        this.getDebugging().setEnabled(value > 0);
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    protected void debug(String msg) {
        this.debug(msg, 1);
    }

    protected void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            this.getDebugging().println(msg);
        }
    }

    protected String generateDebugString(String s) {
        return s;
    }

    protected void logError(String msg) {
        this.m_Errors.add(msg);
    }

    public boolean hasErrors() {
        return !this.m_Errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.m_Errors;
    }

    protected void logWarning(String msg) {
        this.m_Warnings.add(msg);
    }

    public boolean hasWarnings() {
        return !this.m_Warnings.isEmpty();
    }

    public List<String> getWarnings() {
        return this.m_Warnings;
    }

    protected void checkDeprecation(Object object) {
        this.checkDeprecation(object.getClass());
    }

    protected void checkDeprecation(Class cls) {
        if (cls.getAnnotation(Deprecated.class) != null) {
            this.logWarning(cls.getName() + " is deprecated!");
        }
    }

    public void setQuiet(boolean value) {
        this.getSystemErr().setEnabled(!value);
        this.getSystemOut().setEnabled(!value);
    }

    public boolean isQuiet() {
        return !this.getSystemErr().isEnabled();
    }

    public void setSkippedProperties(HashSet<String> value) {
        this.m_SkippedProperties = value;
        this.reset();
    }

    public HashSet<String> getSkippedProperties() {
        return this.m_SkippedProperties;
    }

    protected boolean getUsePropertyNames() {
        return this.m_UsePropertyNames;
    }

    protected String getOptionIdentifier(AbstractOption option) {
        if (this.getUsePropertyNames()) {
            return option.getProperty();
        }
        return "-" + option.getCommandline();
    }

    public OptionHandler getOutput() {
        return this.m_Output;
    }

    public void setInput(C input) {
        this.m_Input = input;
    }

    public C getInput() {
        return this.m_Input;
    }

    protected abstract C convertToInput(String var1);

    protected abstract OptionHandler initOutput();

    protected Method getWriteMethod(AbstractOption option) {
        Method result = option.getWriteMethod();
        if (result == null) {
            this.getSystemErr().println("No write method for option '" + this.getOptionIdentifier(option) + "'!");
        }
        return result;
    }

    protected abstract void processOption(BooleanOption var1, V var2) throws Exception;

    protected abstract void processOption(ClassOption var1, V var2) throws Exception;

    protected abstract void processOption(AbstractArgumentOption var1, V var2) throws Exception;

    protected void processOption(AbstractOption option, V values) throws Exception {
        if (this.m_SkippedProperties.contains(option.getProperty())) {
            return;
        }
        if (option instanceof BooleanOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("processOption/boolean") + ": " + this.getOptionIdentifier(option));
            }
            this.processOption((BooleanOption)option, values);
        } else if (option instanceof ClassOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("processOption/class") + ": " + this.getOptionIdentifier(option));
            }
            this.processOption((ClassOption)option, values);
        } else if (option instanceof AbstractArgumentOption) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("processOption/argument") + ": " + this.getOptionIdentifier(option));
            }
            this.processOption((AbstractArgumentOption)option, values);
        } else {
            throw new IllegalScalingException("Unhandled type of option: " + option.getClass().getName());
        }
    }

    protected abstract void doConsume(OptionManager var1, C var2);

    public OptionHandler consume() {
        this.reset();
        this.m_Output = this.initOutput();
        if (this.isDebugOn()) {
            this.debug(this.generateDebugString("consume/initOutput") + ": " + (this.m_Output == null ? "null" : this.m_Output.getClass().getName()));
        }
        if (this.m_Output != null) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("consume/doConsume") + ": " + this.m_Output.getClass().getName());
            }
            this.doConsume(this.m_Output.getOptionManager(), this.m_Input);
        }
        return this.getOutput();
    }

    public OptionHandler consume(OptionHandler output, C input) {
        this.reset();
        if (output == null) {
            throw new IllegalArgumentException("OptionHandler cannot be null!");
        }
        this.m_Output = output;
        if (this.isDebugOn()) {
            this.debug(this.generateDebugString("consume/createObject") + ": " + (this.m_Output == null ? "null" : this.m_Output.getClass().getName()));
        }
        if (this.m_Output != null) {
            if (this.isDebugOn()) {
                this.debug(this.generateDebugString("consume/doConsume") + ": " + this.m_Output.getClass().getName());
            }
            this.doConsume(this.m_Output.getOptionManager(), input);
        }
        return this.getOutput();
    }

    public OptionHandler fromString(String s) {
        this.reset();
        C content = this.convertToInput(s);
        if (content != null) {
            this.setInput(content);
            this.consume();
        }
        return this.getOutput();
    }

    public OptionHandler fromFile(File file) {
        OptionHandler result = null;
        Vector<String> lines = FileUtils.loadFromFile(file);
        if (lines != null) {
            String content = Utils.flatten(lines, "\n");
            result = this.fromString(content);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionHandler read(String filename) {
        OptionHandler result = null;
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder content = new StringBuilder();
            reader = filename.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            while ((line = reader.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                content.append(line);
            }
            result = this.fromString(content.toString());
        }
        catch (Exception e) {
            this.logError("Failed to read file '" + filename + "': " + e);
            this.getSystemErr().printStackTrace(e);
            result = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Output = null;
        this.m_Input = null;
    }

    public static OptionHandler fromString(Class<? extends AbstractOptionConsumer> cls, String s) {
        OptionHandler result = null;
        try {
            AbstractOptionConsumer consumer = cls.newInstance();
            result = consumer.fromString(s);
            consumer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static OptionHandler fromString(Class<? extends AbstractOptionConsumer> cls, File file) {
        OptionHandler result = null;
        try {
            AbstractOptionConsumer consumer = cls.newInstance();
            result = consumer.fromFile(file);
            consumer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static OptionHandler consume(Class<? extends AbstractOptionConsumer> cls, Object input) {
        OptionHandler result = null;
        try {
            AbstractOptionConsumer consumer = cls.newInstance();
            consumer.setInput(input);
            result = consumer.consume();
            consumer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

