/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractNumericOption;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.lang.reflect.Array;
import java.util.Date;

public class LatexProducer
extends AbstractRecursiveOptionProducer<String, StringBuilder>
implements FileBasedProducer {
    private static final long serialVersionUID = 6207182996484984270L;
    protected boolean m_Landscape;
    protected StringBuilder m_Structure;
    protected StringBuilder m_Details;
    protected int m_Index;

    @Override
    public String globalInfo() {
        return "Generates LaTeX documentation.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsePropertyNames = true;
    }

    public void setLandscape(boolean value) {
        this.m_Landscape = value;
    }

    public boolean getLandscape() {
        return this.m_Landscape;
    }

    public String landscapeTipText() {
        return "Whether to generate a document in landscape format.";
    }

    @Override
    protected String initOutput() {
        return new String();
    }

    protected void addActor(AbstractActor actor, boolean ref) {
        if (ref) {
            this.m_Structure.append("{" + this.getIndentation() + "$\\bullet$ " + this.toLatex(actor.getName()) + " } \n\n");
        } else {
            this.m_Details.append("{" + this.getIndentation() + "$\\bullet$ " + this.toLatex(actor.getName()) + " } \n\n");
        }
    }

    protected String startEnumerate() {
        return "";
    }

    protected String endEnumerate() {
        return "";
    }

    protected String startItemize() {
        return "";
    }

    protected String endItemize() {
        return "";
    }

    protected String toLatex(String s) {
        String result = s;
        result = result.replace("%", "\\%");
        result = result.replace("$", "\\$");
        result = result.replace("_", "\\_");
        result = result.replace("{", "\\{");
        result = result.replace("}", "\\}");
        result = result.replace("@", "$@$");
        result = result.replace("^", "$\\wedge$");
        result = result.replace("*", "$*$");
        result = result.replace("\n", "\\\\ ");
        result = result.replace("\\n", "\\textbackslash n ");
        result = result.replace("\\t", "\\textbackslash t ");
        return result;
    }

    protected String getIndentation() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_Nesting.size(); ++i) {
            result.append("  ");
        }
        result.append("\\hspace{" + Utils.doubleToString(0.3 * (double)this.m_Nesting.size(), 1) + "cm}");
        return result.toString();
    }

    protected String addItem(String value) {
        return "{" + this.getIndentation() + "$\\bullet$ " + this.toLatex(value) + " } \n\n";
    }

    protected String addItem(String name, Object value) {
        return "{" + this.getIndentation() + "$\\bullet$ " + this.toLatex(name) + ": \\texttt{" + this.toLatex("" + value) + "} } \n\n";
    }

    @Override
    public StringBuilder processOption(BooleanOption option) {
        try {
            Object currValue = this.getCurrentValue(option);
            this.m_Details.append(this.addItem(this.getOptionIdentifier(option), currValue));
        }
        catch (Exception e) {
            System.err.println("Error obtaining current value for '" + option.getProperty() + "':");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public StringBuilder processOption(ClassOption option) {
        boolean isActor = ClassLocator.isSubclass(AbstractActor.class, option.getBaseClass());
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            this.m_Structure.append(this.addItem(option.getVariable()));
            this.m_Details.append(this.addItem(this.getOptionIdentifier(option), option.getVariable()));
        } else {
            Object currValue = this.getCurrentValue(option);
            Object currValues = null;
            if (currValue != null) {
                if (!option.isMultiple()) {
                    Object value = currValue;
                    if (isActor) {
                        ++this.m_Index;
                        this.addActor((AbstractActor)value, true);
                        this.addActor((AbstractActor)value, false);
                    }
                    if (value instanceof OptionHandler) {
                        this.m_Details.append(this.startEnumerate());
                        this.m_Nesting.push(new StringBuilder());
                        this.doProduce(((OptionHandler)value).getOptionManager());
                        this.m_Nesting.pop();
                        this.m_Details.append(this.endEnumerate());
                    } else {
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        this.m_Details.append(this.addItem(this.getOptionIdentifier(option), handler.toCommandLine(value)));
                    }
                } else {
                    currValues = currValue;
                    this.m_Details.append(this.addItem(this.getOptionIdentifier(option)));
                    this.m_Details.append(this.startEnumerate());
                    this.m_Nesting.push(new StringBuilder());
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        if (isActor) {
                            ++this.m_Index;
                            this.addActor((AbstractActor)value, true);
                            this.addActor((AbstractActor)value, false);
                        }
                        if (value instanceof OptionHandler) {
                            this.m_Details.append(this.startEnumerate());
                            this.m_Nesting.push(new StringBuilder());
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                            this.m_Details.append(this.endEnumerate());
                            continue;
                        }
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        this.m_Details.append(this.addItem(this.getOptionIdentifier(option), handler.toCommandLine(value)));
                    }
                    this.m_Nesting.pop();
                    this.m_Details.append(this.endEnumerate());
                }
            }
        }
        return null;
    }

    @Override
    public StringBuilder processOption(AbstractArgumentOption option) {
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            this.m_Details.append(this.addItem(this.getOptionIdentifier(option), option.getVariable()));
        } else {
            Object currValue = this.getCurrentValue(option);
            if (currValue != null) {
                if (!option.isMultiple()) {
                    if (!(option instanceof AbstractNumericOption)) {
                        currValue = option.toString(currValue);
                    }
                    this.m_Details.append(this.addItem(this.getOptionIdentifier(option), currValue));
                } else {
                    this.m_Details.append(this.addItem(this.getOptionIdentifier(option), currValue));
                }
            }
        }
        return null;
    }

    @Override
    public String toString() {
        AbstractActor actor = null;
        if (this.m_Input instanceof AbstractActor) {
            // empty if block
        }
        actor = (AbstractActor)this.m_Input;
        StringBuilder result = new StringBuilder();
        result.append("% Generated by " + Environment.getInstance().getProject() + "\n");
        result.append("% " + new Date() + "\n");
        result.append("% " + System.getProperty("user.name") + "\n");
        result.append("\n");
        result.append("\\documentclass[a4paper," + (this.m_Landscape ? "landscape" : "") + "]{article}\n");
        result.append("\\usepackage{hyperref}\n");
        result.append("\\usepackage{dirtree} % http://www.tex.ac.uk/ctan/macros/generic/dirtree/\n");
        result.append("\\setlength{\\parskip}{0pt}\n");
        result.append("\\begin{document}\n");
        result.append("\\section{Structure}\n");
        if (actor != null) {
            result.append("\\textbf{" + this.toLatex(actor.getName()) + "}\n");
            if (!actor.getAnnotations().isEmpty()) {
                result.append("\\ ");
                result.append("\\textit{" + this.toLatex(actor.getAnnotations().getValue()) + "}\n\n");
            }
        }
        result.append(this.startItemize());
        result.append(this.m_Structure.toString());
        result.append(this.endItemize());
        result.append("\\section{Details}\n");
        if (actor != null) {
            result.append(this.toLatex(actor.getName()) + "\n");
        }
        result.append(this.startEnumerate());
        result.append(this.m_Details.toString());
        result.append(this.endEnumerate());
        result.append("\\end{document}\n");
        return result.toString();
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Structure = new StringBuilder();
        this.m_Details = new StringBuilder();
        this.m_Index = 0;
    }

    @Override
    public String getFileFormat() {
        return "LaTeX";
    }

    @Override
    public String getDefaultFileExtension() {
        return "tex";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getDefaultFileExtension()};
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        AbstractActor actor = ActorUtils.read(args[0]);
        String latex = AbstractOptionProducer.toString(LatexProducer.class, actor);
        FileUtils.writeToFile(args[1], latex, false);
    }
}

