/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.Conversion;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class NestedConsumer
extends AbstractRecursiveOptionConsumer<ArrayList, ArrayList> {
    private static final long serialVersionUID = 3076988578982973033L;

    @Override
    public String globalInfo() {
        return "Processes the nested format (tab indentation in string representation, nested ArrayList objects in object representation).";
    }

    protected int getIndentation(String s) {
        int result = 0;
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            ++result;
        }
        return result;
    }

    protected ArrayList linesToNested(ArrayList<String> lines, int[] index, int[] levels) {
        ArrayList<Object> result = new ArrayList<Object>();
        int level = levels[index[0]];
        while (lines.size() > index[0]) {
            if (levels[index[0]] == level) {
                result.add(lines.get(index[0]).substring(level));
                index[0] = index[0] + 1;
                continue;
            }
            if (levels[index[0]] > level) {
                result.add(this.linesToNested(lines, index, levels));
                continue;
            }
            if (levels[index[0]] >= level) continue;
            break;
        }
        return result;
    }

    protected ArrayList linesToNested(ArrayList<String> lines) {
        int[] levels = new int[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            levels[i] = this.getIndentation(lines.get(i));
        }
        ArrayList result = this.linesToNested(lines, new int[]{0}, levels);
        return result;
    }

    @Override
    protected OptionHandler initOutput() {
        OptionHandler result;
        try {
            result = (OptionHandler)Class.forName(Conversion.rename((String)((ArrayList)this.m_Input).get(0))).newInstance();
            ((ArrayList)this.m_Input).remove(0);
            this.m_Input = ((ArrayList)this.m_Input).size() > 0 ? (((ArrayList)this.m_Input).get(0) instanceof ArrayList ? (ArrayList)((ArrayList)this.m_Input).get(0) : new ArrayList()) : new ArrayList();
        }
        catch (Exception e) {
            String msg = "Failed to initialize output:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            result = null;
        }
        return result;
    }

    @Override
    protected ArrayList convertToInput(String s) {
        try {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s.split("\n")));
            while (lines.size() > 0 && lines.get(0).startsWith("#")) {
                lines.remove(0);
            }
            return this.linesToNested(lines);
        }
        catch (Exception e) {
            String msg = "Failed to convert to input:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            return null;
        }
    }

    @Override
    protected void processOption(BooleanOption option, ArrayList values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        method.invoke((Object)option.getOptionHandler(), new Boolean(!option.isInvertingFlag()));
    }

    @Override
    protected void processOption(ClassOption option, ArrayList values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i).getClass() == String.class && Variables.isPlaceholder((String)values.get(i))) {
                option.setVariable((String)values.get(i));
                return;
            }
            ArrayList subset = (ArrayList)values.get(i);
            subset.set(0, Conversion.rename((String)subset.get(0)));
            Object object = Class.forName((String)subset.get(0)).newInstance();
            if (object instanceof OptionHandler) {
                NestedConsumer consumer = new NestedConsumer();
                consumer.setDebugLevel(this.getDebugLevel());
                consumer.setInput(subset);
                object = consumer.consume();
                this.m_Errors.addAll(consumer.getErrors());
                this.m_Warnings.addAll(consumer.getWarnings());
                consumer.cleanUp();
            } else {
                ArrayList optionsSet = subset.size() > 1 ? (ArrayList)subset.get(1) : new ArrayList();
                String[] options = optionsSet.toArray(new String[optionsSet.size()]);
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(object);
                handler.setOptions(object, options);
            }
            Array.set(objects, i, object);
            this.checkDeprecation(object);
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    @Override
    protected void processOption(AbstractArgumentOption option, ArrayList values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (Variables.isPlaceholder((String)values.get(i))) {
                option.setVariable((String)values.get(i));
                return;
            }
            Array.set(objects, i, option.valueOf((String)values.get(i)));
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    protected ArrayList collectValues(AbstractOption option, ArrayList input) {
        ArrayList result = new ArrayList();
        boolean hasArg = option instanceof AbstractArgumentOption;
        int i = 0;
        String optionStr = this.getOptionIdentifier(option);
        while (i < input.size()) {
            if (input.get(i).getClass() == String.class) {
                if (input.get(i).equals(optionStr)) {
                    input.remove(i);
                    if (!hasArg || i >= input.size()) continue;
                    result.add(input.get(i));
                    input.remove(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void doConsume(OptionManager manager, ArrayList input) {
        int i = 0;
        while (i < input.size()) {
            String msg;
            if (input.get(i).getClass() != String.class) {
                ++i;
                continue;
            }
            String cmdline = (String)input.get(i);
            if (cmdline.length() == 0) {
                ++i;
                continue;
            }
            if (!cmdline.startsWith("-")) continue;
            cmdline = cmdline.substring(1);
            AbstractOption option = manager.findByFlag(cmdline);
            ArrayList values = null;
            if (option == null) {
                msg = "Failed to find option (" + manager.getOwner().getClass().getName() + "): " + cmdline;
                this.logWarning(msg);
                this.getSystemErr().println(msg);
                input.remove(i);
                if (i < input.size() && input.get(i).getClass() == String.class) {
                    if (((String)input.get(i)).startsWith("-")) continue;
                    input.remove(i);
                    continue;
                }
                if (i >= input.size()) continue;
                input.remove(i);
                continue;
            }
            if (option instanceof AbstractArgumentOption) {
                values = this.collectValues(option, input);
                if (values.size() == 0) {
                    msg = "No argument supplied for option '" + option + "' (" + manager.getOwner().getClass().getName() + ")!";
                    this.logWarning(msg);
                    this.getSystemErr().println(msg);
                }
            } else if (option instanceof BooleanOption) {
                this.collectValues(option, input);
            }
            try {
                this.processOption(option, values);
            }
            catch (Exception e) {
                msg = "Failed to process option '" + this.getOptionIdentifier(option) + "/" + manager.getOwner().getClass().getName() + "':";
                this.logError(msg + " " + Utils.throwableToString(e));
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
        }
    }
}

