/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.DateFormat;
import adams.core.management.Java;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BlacklistedOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class NestedProducer
extends AbstractRecursiveOptionProducer<ArrayList, ArrayList>
implements BlacklistedOptionProducer {
    private static final long serialVersionUID = 7096746086060792830L;
    public static final String COMMENT = "#";
    protected Class[] m_Blacklisted;
    protected boolean m_OutputProlog;
    protected boolean m_OutputClasspath;
    protected static DateFormat m_DateFormat = new DateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String globalInfo() {
        return "Generates the nested format (tab indentation in string representation, nested ArrayList objects in object representation).";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Blacklisted = new Class[0];
        this.m_OutputProlog = true;
        this.m_OutputClasspath = false;
    }

    @Override
    public void setBlacklisted(Class[] value) {
        if (value == null) {
            value = new Class[]{};
        }
        this.m_Blacklisted = value;
    }

    @Override
    public Class[] getBlacklisted() {
        return this.m_Blacklisted;
    }

    public void setOutputProlog(boolean value) {
        this.m_OutputProlog = value;
    }

    public boolean getOutputProlog() {
        return this.m_OutputProlog;
    }

    public String outputPrologTipText() {
        return "Whether to output the prolog with comments about software version, date/time of generation, etc.";
    }

    public void setOutputClasspath(boolean value) {
        this.m_OutputClasspath = value;
    }

    public boolean getOutputClasspath() {
        return this.m_OutputClasspath;
    }

    public String outputClasspathTipText() {
        return "Whether to output the classpath in the comments as well.";
    }

    @Override
    protected ArrayList initOutput() {
        return new ArrayList();
    }

    @Override
    public ArrayList processOption(BooleanOption option) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Object currValue = this.getCurrentValue(option);
            if (!((Boolean)currValue).equals((Boolean)option.getDefaultValue())) {
                result.add(this.getOptionIdentifier(option));
            }
        }
        catch (Exception e) {
            System.err.println("Error obtaining current value for '" + option.getProperty() + "':");
            e.printStackTrace();
        }
        if (result.size() > 0) {
            if (this.m_Nesting.empty()) {
                ((ArrayList)this.m_Output).addAll(result);
            } else {
                ((ArrayList)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    @Override
    public ArrayList processOption(ClassOption option) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        result.add(this.getOptionIdentifier(option));
                        ArrayList<Object> nested = new ArrayList<Object>();
                        result.add(nested);
                        nested.add(value.getClass().getName());
                        ArrayList<String> nestedDeeper = new ArrayList<String>();
                        nested.add(nestedDeeper);
                        if (value instanceof OptionHandler) {
                            this.m_Nesting.push(nested);
                            this.m_Nesting.push(nestedDeeper);
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                            this.m_Nesting.pop();
                            continue;
                        }
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        nestedDeeper.addAll(Arrays.asList(handler.getOptions(value)));
                    }
                }
            }
        }
        if (this.m_Nesting.empty()) {
            ((ArrayList)this.m_Output).addAll(result);
        } else {
            ((ArrayList)this.m_Nesting.peek()).addAll(result);
        }
        return result;
    }

    @Override
    public ArrayList processOption(AbstractArgumentOption option) {
        ArrayList<String> result = new ArrayList<String>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        result.add(this.getOptionIdentifier(option));
                        result.add(option.toString(Array.get(currValues, i)));
                    }
                }
            }
        }
        if (result.size() > 0) {
            if (this.m_Nesting.empty()) {
                ((ArrayList)this.m_Output).addAll(result);
            } else {
                ((ArrayList)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    protected String getIndentation(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append("\t");
        }
        return result.toString();
    }

    protected void nestedToLines(ArrayList nested, ArrayList<String> lines, int level) {
        for (int i = 0; i < nested.size(); ++i) {
            if (nested.get(i).getClass() == String.class) {
                lines.add(this.getIndentation(level) + nested.get(i));
                continue;
            }
            this.nestedToLines((ArrayList)nested.get(i), lines, level + 1);
        }
    }

    public ArrayList<String> nestedToLines(ArrayList nested) {
        ArrayList<String> result = new ArrayList<String>();
        this.nestedToLines(nested, result, 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result;
        try {
            result = new StringBuilder();
            ArrayList<String> lines = this.nestedToLines((ArrayList)this.getOutput());
            if (this.m_OutputProlog) {
                result.append("# Project: " + Environment.getInstance().getProject() + "\n");
                result.append("# Date: " + m_DateFormat.format(new Date()) + "\n");
                result.append("# User: " + System.getProperty("user.name") + "\n");
                if (this.m_OutputClasspath) {
                    result.append("# Class-Path: " + Java.getClassPath(true) + "\n");
                }
                result.append("#\n");
            }
            for (int i = 0; i < lines.size(); ++i) {
                result.append(lines.get(i));
                result.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        ((ArrayList)this.m_Output).clear();
        ((ArrayList)this.m_Output).add(this.m_Input.getClass().getName());
        ArrayList nested = new ArrayList();
        ((ArrayList)this.m_Output).add(nested);
        this.m_Nesting.push(nested);
    }

    @Override
    public ArrayList doProduce(AbstractOption option) {
        for (int i = 0; i < this.m_Blacklisted.length; ++i) {
            if (option.getReadMethod().getReturnType() != this.m_Blacklisted[i]) continue;
            return null;
        }
        return (ArrayList)super.doProduce(option);
    }

    @Override
    protected void postProduce() {
        super.postProduce();
        this.m_Nesting.pop();
    }
}

