/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversionToString;

public class DoubleToString
extends AbstractConversionToString {
    private static final long serialVersionUID = -9142177169642814841L;
    protected int m_NumDecimals;

    @Override
    public String globalInfo() {
        return "Turns a Double into a String.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", -1, -1, null);
    }

    public void setNumDecimals(int value) {
        if (value >= 0 || value == -1) {
            this.m_NumDecimals = value;
            this.reset();
        } else {
            System.err.println("Number of decimals cannot be negative!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values to use; -1 uses Java's Double.toString() method.";
    }

    @Override
    public Class accepts() {
        return Double.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_NumDecimals == -1) {
            return ((Double)this.m_Input).toString();
        }
        return Utils.doubleToString((Double)this.m_Input, this.m_NumDecimals);
    }
}

