/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseManager;
import adams.db.SQL;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

public class TableManager<T extends SQL>
implements Serializable {
    private static final long serialVersionUID = 7054134442727870486L;
    protected String m_TableName;
    protected Hashtable<String, T> m_Tables;
    protected DatabaseManager m_DatabaseManager;

    public TableManager(String tableName, DatabaseManager manager) {
        this.m_TableName = tableName;
        this.m_Tables = new Hashtable();
        this.m_DatabaseManager = manager;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public boolean hasDatabaseManager() {
        return this.m_DatabaseManager != null;
    }

    public DatabaseManager getDatabaseManager() {
        return this.m_DatabaseManager;
    }

    protected String createURL(AbstractDatabaseConnection dbcon) {
        return dbcon.getUser() + ":" + dbcon.getPassword() + "@" + dbcon.getURL();
    }

    public boolean has(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = this.getDatabaseManager().getDefault();
        }
        return this.m_Tables.containsKey(this.createURL(dbcon));
    }

    public T get(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = this.getDatabaseManager().getDefault();
        }
        return (T)((SQL)this.m_Tables.get(this.createURL(dbcon)));
    }

    public T add(AbstractDatabaseConnection dbcon, T table) {
        if (dbcon == null) {
            if (this.hasDatabaseManager()) {
                dbcon = this.getDatabaseManager().getDefault();
            } else {
                return null;
            }
        }
        SQL result = (SQL)this.m_Tables.put(this.createURL(dbcon), table);
        dbcon.addChangeListener(new DatabaseConnectionChangeListener(){

            @Override
            public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
                if (e.getType() == DatabaseConnectionChangeEvent.Type.DISCONNECT) {
                    e.getDatabaseConnection().removeChangeListener(this);
                    TableManager.this.m_Tables.remove(TableManager.this.createURL(e.getDatabaseConnection()));
                }
            }
        });
        return (T)result;
    }

    public Iterator<T> iterator() {
        return this.m_Tables.values().iterator();
    }

    public String toString() {
        return this.getTableName() + ": " + this.m_Tables.keySet();
    }
}

