/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.condition.bool.AbstractExpression;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.parser.BooleanExpression;
import adams.parser.BooleanExpressionText;
import java.util.HashMap;

public class Expression
extends AbstractExpression {
    private static final long serialVersionUID = -9169161144858552052L;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the expression evaluates to 'true'.\nIn case of integer or double tokens that arrive at the input, these can be accessed in the expression via 'X'; string tokens can be accessed via expression '\"X\"' (surrounding double quotes are required).\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    @Override
    protected BooleanExpressionText getDefaultExpression() {
        return new BooleanExpressionText("true");
    }

    @Override
    public String expressionTipText() {
        return "The expression to evaluate; expressions that consists solely of a variable (eg '@{blah}') get automatically wrapped in parentheses, since the expression string gets interpreted as attached variable instead.";
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        String exp = owner.getVariables().expand(this.getExpression().getValue());
        boolean hasString = exp.indexOf("\"X\"") > -1;
        HashMap symbols = new HashMap();
        if (token != null) {
            if (token.getPayload() instanceof Integer) {
                symbols.put("X", ((Integer)token.getPayload()).doubleValue());
            } else if (token.getPayload() instanceof Double) {
                symbols.put("X", Double.valueOf((Double)token.getPayload()));
            } else if (token.getPayload() instanceof String && hasString) {
                exp = exp.replace("\"X\"", "\"" + token.getPayload() + "\"");
            } else if (token.getPayload() instanceof Report) {
                symbols = BooleanExpression.reportToSymbols((Report)token.getPayload());
            } else if (token.getPayload() instanceof ReportHandler) {
                symbols = BooleanExpression.reportToSymbols(((ReportHandler)token.getPayload()).getReport());
            }
        }
        return this.doEvaluate(exp, symbols);
    }
}

