/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.MutableActorHandler;
import java.util.Vector;

public abstract class MutableControlActor
extends AbstractDirectedControlActor
implements MutableActorHandler {
    private static final long serialVersionUID = 5329012531879115063L;
    protected Vector<AbstractActor> m_Actors;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors = new Vector();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    public void setActors(AbstractActor[] value) {
        ActorUtils.uniqueNames(value);
        this.m_Actors.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Actors.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public abstract String actorsTipText();

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index > -1 && index < this.m_Actors.size()) {
            ActorUtils.uniqueName(actor, this, index);
            this.m_Actors.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getSystemErr().println("Index out of range (0-" + (this.m_Actors.size() - 1) + "): " + index);
        }
    }

    @Override
    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Actors.clear();
        this.reset();
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }
}

