/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.base.BasePassword;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.standalone.AbstractDatabaseConnection;
import java.lang.reflect.Array;

public class ChangeDatabaseConnection
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = -3031404150902143297L;
    protected String m_OldURL;
    protected boolean m_OldURLIsRegExp;
    protected String m_NewURL;
    protected String m_NewUser;
    protected BasePassword m_NewPassword;

    @Override
    public String globalInfo() {
        return "Updates all database connections that match the user-provided URL.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-url", "oldURL", "");
        this.m_OptionManager.add("old-url-is-regexp", "oldURLIsRegExp", false);
        this.m_OptionManager.add("new-url", "newURL", "");
        this.m_OptionManager.add("new-user", "newUser", "");
        this.m_OptionManager.add("new-password", "newPassword", new BasePassword());
    }

    public void setOldURL(String value) {
        this.m_OldURL = value;
        this.reset();
    }

    public String getOldURL() {
        return this.m_OldURL;
    }

    public String oldURLTipText() {
        return "The old JDBC URL to replace.";
    }

    public void setOldURLIsRegExp(boolean value) {
        this.m_OldURLIsRegExp = value;
        this.reset();
    }

    public boolean getOldURLIsRegExp() {
        return this.m_OldURLIsRegExp;
    }

    public String oldURLIsRegExpTipText() {
        return "If enabled, the old URL gets interpreted as regular expression instead of a plain string.";
    }

    public void setNewURL(String value) {
        this.m_NewURL = value;
        this.reset();
    }

    public String getNewURL() {
        return this.m_NewURL;
    }

    public String newURLTipText() {
        return "The new JDBC URL to replace.";
    }

    public void setNewUser(String value) {
        this.m_NewUser = value;
        this.reset();
    }

    public String getNewUser() {
        return this.m_NewUser;
    }

    public String newUserTipText() {
        return "The new database user to use.";
    }

    public void setNewPassword(BasePassword value) {
        this.m_NewPassword = value;
        this.reset();
    }

    public BasePassword getNewPassword() {
        return this.m_NewPassword;
    }

    public String newPasswordTipText() {
        return "The new database password to use.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected boolean isMatch(String url) {
                if (ChangeDatabaseConnection.this.m_OldURLIsRegExp) {
                    return url.matches(ChangeDatabaseConnection.this.m_OldURL);
                }
                return url.equals(ChangeDatabaseConnection.this.m_OldURL);
            }

            protected void process(Object obj) {
                if (obj instanceof AbstractDatabaseConnection) {
                    AbstractDatabaseConnection conn = (AbstractDatabaseConnection)obj;
                    if (!this.isMatch(conn.getURL())) {
                        return;
                    }
                    conn.setURL(ChangeDatabaseConnection.this.m_NewURL);
                    conn.setUser(ChangeDatabaseConnection.this.m_NewUser);
                    conn.setPassword(ChangeDatabaseConnection.this.m_NewPassword);
                    ChangeDatabaseConnection.this.m_Modified = true;
                } else if (obj instanceof adams.db.AbstractDatabaseConnection) {
                    adams.db.AbstractDatabaseConnection conn = (adams.db.AbstractDatabaseConnection)obj;
                    if (!this.isMatch(conn.getURL())) {
                        return;
                    }
                    conn.setURL(ChangeDatabaseConnection.this.m_NewURL);
                    conn.setUser(ChangeDatabaseConnection.this.m_NewUser);
                    conn.setPassword(ChangeDatabaseConnection.this.m_NewPassword);
                    ChangeDatabaseConnection.this.m_Modified = true;
                }
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                Object current = option.getCurrentValue();
                if (option.isMultiple()) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        this.process(Array.get(current, i));
                    }
                } else {
                    this.process(current);
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
    }
}

