/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.core.Placeholders;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.CheckProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.gui.dialog.TextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Array;
import java.util.Vector;

public class CheckPlaceholders
extends AbstractActorProcessor
implements GraphicalOutputProducingProcessor,
CheckProcessor {
    private static final long serialVersionUID = -5756293162246129385L;
    protected Vector<String> m_Errors;

    @Override
    public String globalInfo() {
        return "Checks whether all placeholder files/dirs can be expanded, i.e., whether all placeholders are actually defined.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Errors = new Vector();
    }

    @Override
    protected void processActor(AbstractActor actor) {
        this.m_Errors.clear();
        actor.getOptionManager().traverse(new OptionTraverser(){

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (!ClassLocator.isSubclass(PlaceholderFile.class, option.getBaseClass())) {
                    return;
                }
                if (option.isMultiple()) {
                    Object array = option.getCurrentValue();
                    for (int i = 0; i < Array.getLength(array); ++i) {
                        PlaceholderFile file = (PlaceholderFile)Array.get(array, i);
                        if (Placeholders.isValidStr(file.getAbsolutePath())) continue;
                        CheckPlaceholders.this.m_Errors.add(file.toString());
                    }
                } else {
                    PlaceholderFile file = (PlaceholderFile)option.getCurrentValue();
                    if (!Placeholders.isValidStr(file.getAbsolutePath())) {
                        CheckPlaceholders.this.m_Errors.add(file.toString());
                    }
                }
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
    }

    @Override
    public boolean hasGraphicalOutput() {
        return this.m_Errors.size() > 0;
    }

    @Override
    public String getWarningHeader() {
        return "Files/directories with invalid placeholders:";
    }

    @Override
    public String getWarnings() {
        if (this.m_Errors.size() == 0) {
            return null;
        }
        return Utils.flatten(this.m_Errors, "\n");
    }

    @Override
    public Component getGraphicalOutput() {
        TextPanel result = new TextPanel();
        result.setPreferredSize(new Dimension(400, 300));
        result.setEditable(false);
        result.setContent(Utils.flatten(this.m_Errors, "\n"));
        result.setInfoText(this.getWarningHeader());
        return result;
    }
}

